import pandas as pd
""" 
1. W systemie Windows użyj następującego formatu ścieżki: r"Inne\’nazwa pliku’.csv"
2. Środowisko Python lub Pycharm muszą mieć wgrane pakiet openpyxl w przypadku wczytywania dokumentów Excela:
   $pip3 install openpyxl
3. W przykładach zobaczysz też użycie parametru 'inplace=True' - oznacza on modyfikację oryginalnego obiektu DataFrame,
   a nie tworzenie kopii danych
"""
# Wersja podstawowa tego skryptu:
"""
ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")
ankieta.dropna(inplace=True) # Kasujemy wierszy zawierających puste komórki (NaN)
print("Zaimportowana tabela - usunięte wiersze z 'NaN':\n", ankieta)
"""
# Wersje alternatywne tego skrytu - przypadki są omówione w książce
# Użyj takie wersji jaka jest przydatna w danej sytuacji, usuwając komentarz z wybranej sekcji kodu:

# Sekcja 1.

mojetypy={'Zakres pomiarowy': 'object', 'Cena': 'float64', 'Max': 'uint8', 'Sklep': 'object'}
# Uwaga" w Pandas 'object' to tak naprawdę napis, nazwa jest  myląca
#ankieta = pd.read_csv("Inne/dane1.csv", dtype=mojetypy, delimiter=";", decimal=",")
#ankieta.info()
#print("Zaimportowana tabela - Poprawione typy':\n")
# Uwaga, obecność pustego wiersza wygeneruje błąd "ValueError: Integer column has NA values in column 2"
# Aby uniknąć takiej sytuacji, lepiej jest zmodyfikować typ danych już w pamięci komputera, po załadowaniu
# serii i po jej wyczyszczeniu

# Sekcja 2.

#ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")
#ankieta.loc[1, "Sklep"] ="New York" # Drugi wiersz zostanie poprawiony ('Wrocław' na 'New York')
#print("Zaimportowana tabela - w 2. wierszu poprawiono 'Wrocław' na 'New York':\n", ankieta)

# Sekcja 3.

#ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")
#ankieta.dropna(inplace=True)
#print("Zaimportowana tabela - wykasowano  wiersze zawierające puste komórki, (NaN):\n", ankieta)

# Sekcja 4.

#ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")
#print("Zaimportowana tabela - oryginał:\n", ankieta)
#ankieta.drop_duplicates(inplace=True)
#print("Zaimportowana tabela - wykasowano  wiersze zawierające duplikaty:\n", ankieta)

# Sekcja 5.

#ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")
#ankieta.fillna(250, inplace=True)
#print("Wstawiono wartość 250 do pustych komórek całej tabeli:\n", ankieta)

# Sekcja 6.

#ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")
#ankieta.fillna({"Max": 250}, inplace=True)
#print("Wstawienie do pustych komórek kolumny 'Max' wartości 250:\n", ankieta)

# Sekcja 7.

#ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")
#srednia=ankieta["Max"].mean()
#print("Wartość średnia w kolumnie 'Max'=", srednia)
#ankieta.fillna({"Max": srednia}, inplace=True)
#print("Wstawienie do pustych komórek kolumny'Max' wartości średniej wyliczonej z pozostałych, niezerowych wartości:\n", ankieta)

# Sekcja 8.:

#ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")
#mediana=ankieta["Max"].median()
#print("Mediana w kolumnie 'Max'=", mediana)
#ankieta.fillna({"Max": mediana}, inplace=True)
#print("Wstawienie do pustych komórek kolumny'Max' wartości mediany wyliczonej z pozostałych, niezerowych wartości:\n", ankieta)

# Sekcja 9.

#ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")
#moda=ankieta["Max"].mode()[0]
#print("Moda (najczęściej występująca liczba) w kolumnie 'Max'=", moda)
#ankieta.fillna({"Max": moda}, inplace=True)
#print("Wstawienie do pustych komórek kolumny'Max' tzw. mody wyliczonej z pozostałych, niezerowych wartości:\n", ankieta)

# Sekcja 10.

#ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")
#for x in ankieta.index:
#  if ankieta.loc[x, "Cena"] < 225:
#    ankieta.drop(x, inplace=True)
#print("wykasowanie wybranych wierszy, np. takich dla których wartość w kolumnie 'Cena' wynosi <225:\n", ankieta)

# Sekcja 11.

ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")
print("Zaimportowane typy danych:\n", ankieta.dtypes)
print("Zaimportowana tabela:\n", ankieta)
print("Zaimportowane typy danych:\n", ankieta.dtypes)

# Modyfikacj typu danych w kolumnie:
#ankieta["Max"]=ankieta["Max"].astype('uint8')

print("Zaimportowana tabela:\n", ankieta)

print("Zaimportowane typy danych:\n", ankieta.dtypes)

print("Usuwam kolumnę 'Max':")
ankieta.drop(columns=["Max"], inplace=True)
print("Dodaję kolumnę 'Wartość oczekiwana?' i wypełniam ją wartością 'False':")
ankieta["Wartość oczekiwana?"]=False   # Dodanie nowej kolumny o nazwie "Wartość oczekiwana?"
print("Tabela z dodaną kolumną 'Wartość oczekiwana?':\n", ankieta)
ankieta.info()

# Sekcja 12.

# Oznaczany wartością 'True' w kolumnie „Cena optymalna?” wiersze dla których wartość w kolumnie 'Cena' wynosi 219:
# Sposób 1.: NIEOPTYMALNY
#for x in ankieta.index:
#  if ankieta.loc[x, "Cena"] == 219:
#      ankieta.loc[x, "Cena optymalna?"] = True
# Sposób 2. - dodanie kolumny i wypełnienie jej wartością wynikająca z odczytu wartości z innej kolumny:
print("Cena optymalna:")
ankieta["Cena optymalna?"] = (ankieta["Cena"] == 219)

print(ankieta)

# Przeliczenie wartości w kolumnie:
print("Przeliczenie wartości w kolumnie 'Zakres pom.'")

def funkcyjka(x):
    if x=='pon.-czw.':
        return "Dni robocze"
    elif x=='piątek':
        return "Piątek"
    else:
        return "Dni promocyjne"
ankieta["Zakres pomiarowy"] = ankieta["Zakres pomiarowy"].apply(funkcyjka)

print(ankieta)