import pandas as pd

# Odczyt plików Excela wymaga obecności pakietu openpyxl w środowisku - użyj pip lub dodaj go w Pycharmie do projektu

# CSV:  W systemie Windows użyj następującego formatu ścieżki: r"Inne\'nazwa pliku'.csv"
# XLSX: W systemie Windows użyj następującego formatu ścieżki: r"Inne\'nazwa pliku'.xlsx"

# Aby aktywować kod usuń znak komentarza przed wybranymi liniami "#ankieta = ...."

# Warianty odczytu CSV

# 1) Wersja domyślna, poprawny układ z wierszem nagłówkowym. Tu i dalej
#    separatorem jest symbol średnika, nie przecinek, podobnie symbolem dziesiętnym jest przecinek, nie kropka!

#ankieta = pd.read_csv("Inne/dane1.csv", delimiter=";", decimal=",")

# 2) Brak wiersza nagłówkowego:
#ankieta = pd.read_csv("Inne/dane2.csv", header=None, names=["nazwa1","nazwa2","nazwa3", "nazwa4"], delimiter=";", decimal=",")

# 3) Jest wiersz nagłówkowy, ale definiujmy nasz własny nagłówek nadpisując domyślny:
#ankieta = pd.read_csv("Inne/dane1.csv", header=0, names=["nazwa1","nazwa2","nazwa3", "nazwa4"], delimiter=";", decimal=",")

# Warianty odczytu pliku Excela
# 1) Wersja domyślna, tabela w pierwszej zakładce
#ankieta = pd.read_excel("Inne/dane1.xlsx")

# 2) Brak wiersza nagłówkowego i tabela zawarta jest w innej, niż pierwsza zakładce (tutaj: 'ArkuszExtra')
#ankieta = pd.read_excel("Inne/dane2.xlsx", sheet_name='ArkuszExtra', header=None, names=["nazwa1","nazwa2","nazwa3", "nazwa4"])

# 3) Jest obecny wiersz nagłówkowy, tabela zawarta w 'ArkuszExtra2' i przesunięta w dół o 1 wiersz:
ankieta = pd.read_excel("Inne/dane2.xlsx", sheet_name='ArkuszExtra2', header=1)

print("Tak Pandas zinterpretowała dane:")
ankieta.info()
print("Cała tabela:\n", ankieta)

print("Kształt tabeli:", ankieta.shape) # W naszym przykładzie zwróci (19,4)
print("Liczba wierszy:", ankieta.shape[0]) # W naszym przykładzie zwróci 19

print("Czytamy 3 wiersze z przodu:\n", ankieta.head(3))
print("Czytamy cały plik oprócz 6 ostatnich wierszy:\n", ankieta.head(-6))
print("Czytamy 2 wiersze od tyłu:\n",  ankieta.tail(2))



