import pandas as pd
import numpy as np
from openai import OpenAI
from scipy.spatial import distance
API_KEY = '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' # Patrz uwagi w książce "Bezpieczeństwo klucza API"
client = OpenAI(api_key=API_KEY)

def wylicz_wektor(s, m):
    s = s.replace("\n", " ")
    resp = client.embeddings.create(
        input=s,
        model = m).data[0].embedding
    return resp

model1 = 'text-embedding-ada-002'
model2 ='text-embedding-3-large'
model3 = 'text-embedding-3-small'

zapytanie_napis  = 'Posiadacie coś, co mi pozwoli utrzymać czystość w kuchni? Zmywanie po dzieciach\
                    i zwierzakach domowych to koszmar i nie jest zbyt ekologiczne zwłaszcza\
                    jeśli to robię ręcznie'

zapytanie_wector = wylicz_wektor(zapytanie_napis, model1)

towary = pd.read_excel('towary.xlsx')
towary['Embed'] = towary.apply(lambda row: wylicz_wektor(row['Nazwa'] + ' ' + row['Opis'], model1), axis=1)
towary['Odleglosc'] = towary['Embed'].apply(lambda embed: distance.cosine(embed, zapytanie_wector))
towary.to_excel('towary-indeksy.xlsx', index=False)

najmniejsza_odleglosc_wiersz = towary.loc[towary['Odleglosc'].idxmin()]

print("Najbliższy wynik:")
print("Nr wiersza:", najmniejsza_odleglosc_wiersz.name)
print("SKU:", najmniejsza_odleglosc_wiersz['SKU'])
print("Nazwa:", najmniejsza_odleglosc_wiersz['Nazwa'])
print("Opis:", najmniejsza_odleglosc_wiersz['Opis'])
