import spacy

text=("""We spent 2 weeks in N.Y. in June 2024. During our stay John Biden visited
 one of local primary schools located close to our hotel and all the roads were
 totally blocked""")

print ("Tekst do analizy:\n", text)
print ("Analiza NER - język angielski:")
print(".-----------------------------------------------------------------.")
print(" Jednostka NER    | Etykieta  |   Objaśnienie")
print(".-----------------------------------------------------------------.")
#spacy.cli.download("en_core_web_sm") # Patrz "Instalacja i konfiguracja spaCy" (dotyczy Pycharm)
nlp = spacy.load("en_core_web_sm")

doc = nlp(text)
for ent in doc.ents:
    print(f"{ent.text:17} {ent.label_:13} {str(spacy.explain(ent.label_))}")
print("\nPełna lista etykiet NER i ich opisów dla języka angielskiego:\n")
for label in nlp.get_pipe("ner").labels:
    print(f"{label:12} {spacy.explain(label)}")
