import pandas as pd
from sklearn.preprocessing import StandardScaler
df = pd.read_excel('outliers.xlsx', header=0)
scaler = StandardScaler()
scaled_df = pd.DataFrame(scaler.fit_transform(df), columns=df.columns)

print("*******Tabela przed standaryzacją:\n", df)

outliers = scaled_df[~((scaled_df < 3) & (scaled_df > -3)).all(axis=1)]

print("****** outliers ******")
print(outliers)
outliers.info()
print("Wartości odstające:")
print(outliers)

# Połączenie oryginalnych i przeskalowanych
cdf = pd.concat([df, scaled_df.add_suffix('_std')], axis=1)
cdf.to_excel('outliers_all.xlsx', index=True)

wzrost_99 = df['wzrost'].quantile(0.99)
wiek_99 = df['wiek'].quantile(0.99)

outliers_wiek   = df[df['wiek']   > wiek_99]
outliers_wzrost = df[df['wzrost'] > wzrost_99]
print("Wartości odstające 'wiek' na podstawie analizy danych pierwotnych:")
print(outliers_wiek)
print("Wartości odstające 'wzrost' na podstawie analizy danych pierwotnych:")
print(outliers_wzrost)