import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
t = np.array([-80, -50, 0, 10, 12, 15, 17, 60, 65, 70, 80, 80, 80, 180, 185, 186, 190, 200, 220, 250, 200, 320, 350, 370, 600, 650, 700, 800, 800, 800, 800, 850, 960, 1200])
fig, axes = plt.subplots(1, 2, figsize=(14, 6))
axes[0].scatter(np.arange(len(t)), t, color='green', label='Wykres punktowy')
axes[0].set_title('Wykres punktowy')
axes[0].set_xlabel('X')
axes[0].set_ylabel('Wartość')
axes[0].legend()
sns.violinplot(ax=axes[1], data=t, inner='quartile')
axes[1].set_title('Wykres skrzypcowy')
axes[1].set_xlabel('Rozkład')
axes[1].set_ylabel('Wartość')
plt.tight_layout()
plt.show()
