import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from sklearn.cluster import KMeans
data = pd.read_excel('dane2D.xlsx')
X = data[['wiek', 'punktacja']].values
wcss = []
for i in range(1, 11):
    kmeans = KMeans(n_clusters=i, init="k-means++", random_state=42)
    kmeans.fit(X)
    wcss.append(kmeans.inertia_)
plt.plot(range(1, 11), wcss)
#plt.title('Metoda Elbow')
plt.xlabel('Liczba klastrów')
plt.ylabel('WCSS')
#plt.gca().ticklabel_format(style='plain')  # zmiana formatu etykiet osi Y, zamiast kompresjo do formatu x*10^9 (le9)
plt.show()
k = np.argmin(np.diff(wcss)) + 2
print("Wybrana liczba klastrów na podstawie metody 'łokcia':", k)
k=2 # Możesz poeksperymentować z własnymi wartościami

kmeans = KMeans(n_clusters=k, init="k-means++", random_state=42)
y_pred = kmeans.fit_predict(X)

def get_marker(cluster):
    markers = ['o', 's', '^', 'P', 'D']
    return markers[cluster % len(markers)]

for cluster_id in np.unique(y_pred):
    plt.scatter(X[y_pred == cluster_id, 0], X[y_pred == cluster_id, 1], marker=get_marker(cluster_id), label=f'Klaster {cluster_id}')
plt.scatter(kmeans.cluster_centers_[:, 0], kmeans.cluster_centers_[:, 1], s=200, c='black', marker='P', label='Centroidy')
plt.title(f"K-Means (k={k})")
plt.xlabel('Wiek')
plt.ylabel('Punktacja')
plt.legend()
plt.show()

data['klaster'] = y_pred
data.to_excel('dane2D-wynikiKMeans.xlsx', index=False)
print(data.head(300))

# Predykcje
probka = pd.DataFrame([[27, 7340]], columns=['wiek', 'punktacja'])
nowy_klaster = kmeans.predict(probka.values)
print("Przewidziany numer klastra dla nowej próbki danych:", nowy_klaster[0])