#
# Testy historyczne bazujące na zdarzeniach
# -- klasa bazowa (2)
#
# (c) Dr Yves J. Hilpisch
#
from backtesting import *


class BacktestingBaseRM(BacktestingBase):

    def set_prices(self, price):
        ''' Zapisywanie cen na potrzeby śledzenia wyników,
            na przykład w celu sprawdzania aktywowania zlecenia trailing stop loss.
        '''
        self.entry_price = price  # <1>
        self.min_price = price  # <2>
        self.max_price = price  # <3>

    def place_buy_order(self, bar, amount=None, units=None, gprice=None):
        ''' Składa zlecenia kupna dla danego słupka 
            z określoną kwotą lub liczbą jednostek.
        '''
        date, price = self.get_date_price(bar)
        if gprice is not None:
            price = gprice
        if units is None:
            units = int(amount / price)
        self.current_balance -= (1 + self.ptc) * units * price + self.ftc
        self.units += units
        self.trades += 1
        self.set_prices(price)  # <4>
        if self.verbose:
            print(f'{date} | kupno {units} jednostek po {price:.4f}')
            self.print_balance(bar)

    def place_sell_order(self, bar, amount=None, units=None, gprice=None):
        ''' Składa zlecenie sprzedaży dla danego słupka 
            z określoną kwotą lub liczbą jednostek.
        '''
        date, price = self.get_date_price(bar)
        if gprice is not None:
            price = gprice
        if units is None:
            units = int(amount / price)
        self.current_balance += (1 - self.ptc) * units * price - self.ftc
        self.units -= units
        self.trades += 1
        self.set_prices(price)  # <4>
        if self.verbose:
            print(f'{date} | sprzedaż {units} jednostek po {price:.4f}')
            self.print_balance(bar)
