class CricketPage {
  
  protected void Page_Load(object sender, System.EventArgs e) {
    db = new OleDbConnection(DB.ConnectionString);
    if (hasMissingParameters())
      errorTransfer (missingParameterMessage);
    DataSet ds = getData();
    if (hasNoData(ds))
      errorTransfer ("Nie odnaleziono danych speniajcych kryteria.");
    applyDomainLogic (ds);
    DataBind();
    prepareUI(ds);
  }
  
  //-----
  
  abstract protected String[] mandatoryParameters();
  private Boolean hasMissingParameters() {
    foreach (String param in mandatoryParameters())
      if (Request.Params[param] == null
        return true;
    return false;
  }
  
  
  private String missingParameterMessage {
    get {
      String result = "<P>Poniej wymieniono brakujce niezbdne parametry:</P>";
      result += "<UL>";
      foreach (String param in mandatoryParameters())
        if (Request.Params[param] == null)
          result += String.Format("<LI>{0}</LI>", param);
      result += "</UL>";
      return result;
    }
  }
  
  protected void errorTransfer(String message) {
    Context.Items.Add("errorMessage", message);
    Context.Server.Transfer("Error.aspx");
  }
  
  abstract protected DataSet getData();
  
  protected Boolean hasNoData(DataSet ds) {
    foreach (DataTable table in ds.Tables) 
      if (table.Rows.Count != 0) return false;
    return true;
  }
  
  
  protected virtual void applyDomainLogic (DataSet dc) {}
  
}


//###################################################################

class BattingPage {
  
  override protected String[] mandatoryParameters() {
    String[] result = { "team", "innings", "match" };
    return result;
  }
  
  override protected DataSet getData() {
    OleDbCommand command = new OleDbCommand(SQL, db);
    command.Parameters.Add(new OleDbParameter("team", team);
    command.Parameters.Add(new OleDbParameter("innings", innings);
    command.Parameters.Add(new OleDbParameter("match", match);
    OleDbDataAdapter da = new OleDbDataAdapter(command);
    DataSet result = new DataSet();
    da.Fill(result, Batting.TABLE_NAME);
    return result;
  }
  
  private const String SQL = 
      @"SELECT * from batting
         WHERE team = ? AND innings = ? AND matchID = ?
         ORDER BY battingOrder";
  
  //--
  
  override protected void applyDomainLogic (DataSet dataSet) {
    batting = new Batting(dataSet);
    batting.CalculateRates();
  }
  
  
  protected String team {
    get { return Request.Params["team"];}
  }
  protected String match {
    get { return Request.Params["match"];}
  }
  protected String innings {
    get { return Request.Params["innings"];}
  }
  protected String ordinalInnings{
    get {return (innings == "1") ? "1." : "2.";}
  }
  
  
  override protected void prepareUI(DataSet ds) {
    DataGrid1.DataSource = ds;
    DataGrid1.DataBind();
  }
  
}
