class UnitOfWork {
  
  private List read = new ArrayList();
  
  public void registerRead(DomainObject object) {
    reads.add(object);
  }
  
  public void commit() {
    try {
      checkConsistentReads();
      insertNew();
      deleteRemoved();
      updateDirty();
    } catch (ConcurrencyException e) {
      rollbackSystemTransaction();
      throw e;
    }
  }
  
  public void checkConsistentReads() {
    for (Iterator iterator = reads.iterator(); iterator.hasNext(); ) {
      DomainObject dependtent = (DomainObject) iterator.next();
      dependent.getVersion.increment();
    }
  } 
  
}

//--- druga wersja (448)

class UnitOfWork {
  
  public void commit() throws SQLException {
    for (Iterator iterator = _modifiedObjects.iterator(); iterator.hasNext();) {
      DomainObject object = (DomainObject) iterator.next();
      for (DomainObject owner = object; owner != null; owner = owner.getParent) {
        owner.getVersion().increment();
      }
    }
    for (Iterator interator = _modifiedObjects.iterator(); iterator.hasNext();) {
      DomainObject object = (DomainObject) iterator.next();
      Mapper mapper = MapperRegistry.getMapper(object.getClass());
      mapper.update(object);
    }
  }
  
}