class ExclusiveReadLockManagerDBImpl implements ExclusiveReadLockManager {
  
  private static final String INSERT_SQL = 
        "insert into lock values(?, ?)";
  private static final String DELETE_SINGLE_SQL = 
        "delete from lock where lockableid = ? and ownerid = ?";
  private static final String DELETE_ALL_SQL = 
        "delet from lock where ownerid = ?";
  private static final String CHECK_SQL = 
        "select lockableid from lock where lockableid = ? and owner = ?";
  
  public void acquireLock(Long lockable, String owner) throws ConcurrencyException {
    if (!hasLock(lockable, owner)) {
      Connectin conn = null;
      PreparedStatement pstmt = null;
      try {
        conn = ConnectionManager.INSTANCE.getConnection();
        pstmt = conn.prepareStatement(INSERT_SQL);
        pstmt.setLong(1, lockabl.longValue());
        pstmt.setString(2, owner);
        pstmt.executeUpdate();
      } catch (SQLException sqlEx) {
        throw new ConcurrencyException("Nie mona uzyska blokady " + lockable);
      } finally {
        closeDBResources(conn, pstmt);
      }
    }
  }
  
  public void releaseLock(Long lockable,  String owner) {
    Connection conn = null;
    PreparedStatement pstmt = null;
    try {
      conn = ConnectionManager.INSTANCE.getConnection();
      pstmt = conn.prepareStatement(DELETE_SINGLE_SQL);
      pstmt.setLong(1, lockable.longValue());
      pstmt.setString(2, owner);
      pstmt.executeUpdate();
    } catch (SQLException sqlEx) {
      throw new SystemException("Nieoczekiwany bd podczas zwalniania blokady obiektu " + lockable);
    } finally {
      closeDBResources(conn, pstmt);
    }
  }
  
  
}