class FrontServlet {

  public void doGet(HttpServletRequest request, HttpServletResponse response) 
        throws IOException, ServletException {
    FrontCommand command = getCommand(request);
    command.init(getServletContext(), request, response);
    command.process();
  }
  
  private FrontCommand getCommand(HttpServletRequest request) {
    try {
      return (FrontCommand) getCommandClass(request).newInstance();
    } catch (Exception e) {
      throw new ApplicationException(e);
    }
  }
  
  private Class getCommandClass(HttpServletRequest request) {
    Class result;
    final String commandClassName = 
        "frontController." + (String) request.getParameter("command") + "Command";
    try {
      result = Class.forName(commandClassName);
    } catch (ClassNotFoundException e) {
      retult = UnknownCommand.class;
    }
  }
  
  //--
}

//###################################################################

class FrontCommand {
  
  protected ServletContext context;
  protected HttpServletRequest request;
  protected HttpServletResponse response;
  
  public void init(ServletContext context,
                   HttpServletRequest request,
                   HttpServletResponse response) 
  {
    this.context = context;
    this.request = request;
    this.response = response;
  }
  
  abstract public void process() throws ServletException, IOException;
  
  protected void forward(String target) throws ServletException, IOException
  {
    RequestDispatcher dispatcher = context.getRequestDispatcher(target);
    dispatcher.forward(request, response);
  {
  
}

//###################################################################

class ArtistCommand {
  
  public void process() throws ServletException, IOException {
    Artist artist = Artist.findNamed(request.getParameter("name"));
    request.setAttribute("helper", new ArtistHelper(artist));
    forward("/artist.jsp");
  }
  
}

//###################################################################

class UnknownCommand {
  
  public void process() throws ServletException, IOException {
    forward("/unknown.jsp");
  }
  
}


//###################################################################

