class ArtistController {

  public void doGet(HttpServletRequest request, HttpServletResponse response) 
      throws IOException, ServletException {
    Artist artist = Artist.findNamed(request.getParameter("name"));
    if (artist == null)
      forward("/MissingArtistError.jst", request, response);
    else {
      request.setAttribute("helper", new ArtistHelper(artist));
      forward("/artist.jsp", request, response);
    }
  }
  
}

//###################################################################

class ActionServlet {
  
  protected void forward(String target,
                   HttpServletRequest request,
                   HttpServletResponse response)
      throws IOException, ServletException
  {
    RequestDispatcher dispatcher = getServletContext().getRequestDispatcher(target);
    dispatcher.forward(request, response);
  }
  
}


//###################################################################

class AlbumController {
  
  public void doGet(HttpServletRequest request, HttpServletResponse response)
      throws IOException, ServletException
  {
    Album = Album.find(request.getParameter("id"));
    if (album == null) {
      forward("/missingAlbumError.jsp", request, response);
      return;
    }
    request.setAttribute("helper", album);
    if (album instanceof ClassicalAlbum)
      forward("/classicalAlbum.jsp", request, response);
    else
      forward("/album.jsp", request, response);
  }
  
}



//##