# Chapter 1: Introduction
This is a companion repository for _Making Embedded Systems, 2nd Ed._ by Elecia White. 


# Following Along in the Book
[A detailed explanation of breakpoints](https://interrupt.memfault.com/blog/cortex-m-breakpoints) from Memfault's Interrupt Blog. 

# What Happens Before main() Runs

Want to know what happens before main? The [True Story of Hello World](https://www.lisha.ufsc.br/teaching/os/exercise/hello.html) is a blog post that talks about going from code through compiling and linking, then into loading and running. It is linux based but the steps are very relevant to embedded systems. 

For something more hardware and embedded centric this video about the [Cortex-M boot process](https://www.youtube.com/watch?v=3brOzLJmeek) is very good.

For a shorter version, the Interrupt blog goes over [Zero to Main](https://interrupt.memfault.com/blog/zero-to-main-1).

For an even terser version, check out a startup assembly file [startup_stm32l053xx.S](https://github.com/ARMmbed/mbed-os/blob/master/targets/TARGET_STM/TARGET_STM32L0/TARGET_STM32L053x8/TOOLCHAIN_GCC_ARM/startup_stm32l053xx.S).


# Final Note
If you like what's here, please consider buying the book: [_Making Embedded Systems, 2nd Ed._](https://learning.oreilly.com/library/view/making-embedded-systems/9781098151539/) by Elecia White
