<?php

/**
 * Artykul form base class.
 *
 * @method Artykul getObject() Returns the current form's model object
 *
 * @package    artykuly
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseArtykulForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'artykul_id' => new sfWidgetFormInputHidden(),
      'tytul'      => new sfWidgetFormInputText(),
      'lid'        => new sfWidgetFormTextarea(),
      'spistresci' => new sfWidgetFormTextarea(),
      'tresc'      => new sfWidgetFormTextarea(),
      'slug'       => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'artykul_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getArtykulId()), 'empty_value' => $this->getObject()->getArtykulId(), 'required' => false)),
      'tytul'      => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'lid'        => new sfValidatorString(array('required' => false)),
      'spistresci' => new sfValidatorString(array('required' => false)),
      'tresc'      => new sfValidatorString(array('required' => false)),
      'slug'       => new sfValidatorString(array('max_length' => 128, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Artykul', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('artykul[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Artykul';
  }


}
