<?php

/**
 * TurniejHasZawodnik form base class.
 *
 * @method TurniejHasZawodnik getObject() Returns the current form's model object
 *
 * @package    tcs
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseTurniejHasZawodnikForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'thz_id'      => new sfWidgetFormInputHidden(),
      'turniej_id'  => new sfWidgetFormPropelChoice(array('model' => 'Turniej', 'add_empty' => false)),
      'zawodnik_id' => new sfWidgetFormPropelChoice(array('model' => 'Zawodnik', 'add_empty' => false)),
      'miejsce'     => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'thz_id'      => new sfValidatorChoice(array('choices' => array($this->getObject()->getThzId()), 'empty_value' => $this->getObject()->getThzId(), 'required' => false)),
      'turniej_id'  => new sfValidatorPropelChoice(array('model' => 'Turniej', 'column' => 'turniej_id')),
      'zawodnik_id' => new sfValidatorPropelChoice(array('model' => 'Zawodnik', 'column' => 'zawodnik_id')),
      'miejsce'     => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('turniej_has_zawodnik[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'TurniejHasZawodnik';
  }


}
