<?php

class propelImportdanychTask extends sfBaseTask
{
  protected function configure()
  {
    // // add your own arguments here
    // $this->addArguments(array(
    //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
    // ));

    $this->addOptions(array(
      new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
      new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
      new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
      // add your own options here
    ));

    $this->namespace        = 'propel';
    $this->name             = 'import-danych';
    $this->briefDescription = '';
    $this->detailedDescription = <<<EOF
The [propel:import-danych|INFO] task does things.
Call it with:

  [php symfony propel:import-danych|INFO]
EOF;
  }

  protected function execute($arguments = array(), $options = array())
  {
    // initialize the database connection
    $databaseManager = new sfDatabaseManager($this->configuration);
    $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

    // add your code here


    require_once 'lib/slugs.inc.php';

    TrenPeer::doDeleteAll();
    
    $plks = glob('data/txt/treny/*.txt');
    shuffle($plks);
    foreach ($plks as $plk) {
        echo $plk . "\n";

        $path_parts = pathinfo($plk);
        $numer = ltrim($path_parts['filename'], '0');

        $p = file($plk);
        $tytul = trim($p[0]);
        $slug = string2slug($tytul);
        $p[0] = '';
        $tresc = trim(implode('', $p));

        $tren = new Tren();
        $tren->setTytul($tytul);
        $tren->setTresc($tresc);
        $tren->setSlug($slug);
        $tren->setNumer($numer);
        $tren->save();
    }


  }
}
