set names utf8;
drop database if exists tcs;
create database tcs default character set utf8 collate utf8_polish_ci;
grant all on tcs.* to redaktor@localhost identified by 'tajnehaslo';
flush privileges;
use tcs;


-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 07 Gru 2010, 12:33
-- Wersja serwera: 5.1.44
-- Wersja PHP: 5.2.13

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `tcs`
--

-- --------------------------------------------------------

--
-- Struktura tabeli dla  `panstwo`
--

CREATE TABLE IF NOT EXISTS `panstwo` (
  `panstwo_id` int(11) NOT NULL AUTO_INCREMENT,
  `panstwo` varchar(128) COLLATE utf8_polish_ci DEFAULT NULL,
  PRIMARY KEY (`panstwo_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci AUTO_INCREMENT=15 ;

--
-- Zrzut danych tabeli `panstwo`
--

INSERT INTO `panstwo` (`panstwo_id`, `panstwo`) VALUES
(1, 'Austria'),
(2, 'Norwegia'),
(3, 'Finlandia'),
(4, 'Związek Socjalistycznych Republik Radzieckich'),
(5, 'Republika Federalna Niemiec'),
(6, 'Niemiecka Republika Demokratyczna'),
(7, 'Czechosłowacja'),
(8, 'Szwajcaria'),
(9, 'Kanada'),
(10, 'Niemcy'),
(11, 'Japonia'),
(12, 'Czechy'),
(13, 'Słowenia'),
(14, 'Polska');

-- --------------------------------------------------------

--
-- Struktura tabeli dla  `sf_guard_group`
--

CREATE TABLE IF NOT EXISTS `sf_guard_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  `description` text COLLATE utf8_polish_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sf_guard_group_U_1` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci AUTO_INCREMENT=1 ;

--
-- Zrzut danych tabeli `sf_guard_group`
--


-- --------------------------------------------------------

--
-- Struktura tabeli dla  `sf_guard_group_permission`
--

CREATE TABLE IF NOT EXISTS `sf_guard_group_permission` (
  `group_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`group_id`,`permission_id`),
  KEY `sf_guard_group_permission_FI_2` (`permission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

--
-- Zrzut danych tabeli `sf_guard_group_permission`
--


-- --------------------------------------------------------

--
-- Struktura tabeli dla  `sf_guard_permission`
--

CREATE TABLE IF NOT EXISTS `sf_guard_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  `description` text COLLATE utf8_polish_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sf_guard_permission_U_1` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci AUTO_INCREMENT=1 ;

--
-- Zrzut danych tabeli `sf_guard_permission`
--


-- --------------------------------------------------------

--
-- Struktura tabeli dla  `sf_guard_remember_key`
--

CREATE TABLE IF NOT EXISTS `sf_guard_remember_key` (
  `user_id` int(11) NOT NULL,
  `remember_key` varchar(32) COLLATE utf8_polish_ci DEFAULT NULL,
  `ip_address` varchar(50) COLLATE utf8_polish_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`,`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

--
-- Zrzut danych tabeli `sf_guard_remember_key`
--


-- --------------------------------------------------------

--
-- Struktura tabeli dla  `sf_guard_user`
--

CREATE TABLE IF NOT EXISTS `sf_guard_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(128) COLLATE utf8_polish_ci NOT NULL,
  `algorithm` varchar(128) COLLATE utf8_polish_ci NOT NULL DEFAULT 'sha1',
  `salt` varchar(128) COLLATE utf8_polish_ci NOT NULL,
  `password` varchar(128) COLLATE utf8_polish_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `is_active` tinyint(4) NOT NULL DEFAULT '1',
  `is_super_admin` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sf_guard_user_U_1` (`username`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci AUTO_INCREMENT=2 ;

--
-- Zrzut danych tabeli `sf_guard_user`
--

INSERT INTO `sf_guard_user` (`id`, `username`, `algorithm`, `salt`, `password`, `created_at`, `last_login`, `is_active`, `is_super_admin`) VALUES
(1, 'admin', 'sha1', '8e27d468bd637f82449ed740242f38bd', 'c8fc83ef77fc2ed9380d0640327eacfe8325507c', '2010-12-07 12:32:47', NULL, 1, 1);

-- --------------------------------------------------------

--
-- Struktura tabeli dla  `sf_guard_user_group`
--

CREATE TABLE IF NOT EXISTS `sf_guard_user_group` (
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `sf_guard_user_group_FI_2` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

--
-- Zrzut danych tabeli `sf_guard_user_group`
--


-- --------------------------------------------------------

--
-- Struktura tabeli dla  `sf_guard_user_permission`
--

CREATE TABLE IF NOT EXISTS `sf_guard_user_permission` (
  `user_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`permission_id`),
  KEY `sf_guard_user_permission_FI_2` (`permission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

--
-- Zrzut danych tabeli `sf_guard_user_permission`
--


-- --------------------------------------------------------

--
-- Struktura tabeli dla  `turniej`
--

CREATE TABLE IF NOT EXISTS `turniej` (
  `turniej_id` int(11) NOT NULL AUTO_INCREMENT,
  `rok` int(11) DEFAULT NULL,
  PRIMARY KEY (`turniej_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci AUTO_INCREMENT=56 ;

--
-- Zrzut danych tabeli `turniej`
--

INSERT INTO `turniej` (`turniej_id`, `rok`) VALUES
(1, 1953),
(2, 1954),
(3, 1955),
(4, 1956),
(5, 1957),
(6, 1958),
(7, 1959),
(8, 1960),
(9, 1961),
(10, 1962),
(11, 1963),
(12, 1964),
(13, 1965),
(14, 1966),
(15, 1967),
(16, 1968),
(17, 1969),
(18, 1970),
(19, 1971),
(20, 1972),
(21, 1973),
(22, 1974),
(23, 1975),
(24, 1976),
(25, 1977),
(26, 1978),
(27, 1979),
(28, 1980),
(29, 1981),
(30, 1982),
(31, 1983),
(32, 1984),
(33, 1985),
(34, 1986),
(35, 1987),
(36, 1988),
(37, 1989),
(38, 1990),
(39, 1991),
(40, 1992),
(41, 1993),
(42, 1994),
(43, 1995),
(44, 1996),
(45, 1997),
(46, 1998),
(47, 1999),
(48, 2000),
(49, 2001),
(50, 2002),
(51, 2003),
(52, 2004),
(53, 2005),
(54, 2006),
(55, 2007);

-- --------------------------------------------------------

--
-- Struktura tabeli dla  `turniej_has_zawodnik`
--

CREATE TABLE IF NOT EXISTS `turniej_has_zawodnik` (
  `thz_id` int(11) NOT NULL AUTO_INCREMENT,
  `turniej_id` int(11) NOT NULL,
  `zawodnik_id` int(11) NOT NULL,
  `miejsce` int(11) DEFAULT NULL,
  PRIMARY KEY (`thz_id`),
  KEY `fk_turniej_has_zawodnik_turniej1` (`turniej_id`),
  KEY `fk_turniej_has_zawodnik_zawodnik1` (`zawodnik_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci AUTO_INCREMENT=166 ;

--
-- Zrzut danych tabeli `turniej_has_zawodnik`
--

INSERT INTO `turniej_has_zawodnik` (`thz_id`, `turniej_id`, `zawodnik_id`, `miejsce`) VALUES
(1, 1, 1, 1),
(2, 1, 2, 2),
(3, 1, 3, 3),
(4, 2, 4, 1),
(5, 2, 5, 2),
(6, 2, 1, 3),
(7, 3, 6, 1),
(8, 3, 5, 2),
(9, 3, 7, 3),
(10, 4, 8, 1),
(11, 4, 1, 2),
(12, 4, 9, 3),
(13, 5, 10, 1),
(14, 5, 5, 2),
(15, 5, 11, 3),
(16, 6, 12, 1),
(17, 6, 9, 2),
(18, 6, 8, 3),
(19, 7, 12, 1),
(20, 7, 13, 2),
(21, 7, 14, 3),
(22, 8, 11, 1),
(23, 8, 15, 2),
(24, 8, 16, 3),
(25, 9, 12, 1),
(26, 9, 16, 2),
(27, 9, 17, 3),
(28, 10, 5, 1),
(29, 10, 18, 2),
(30, 10, 6, 3),
(31, 11, 19, 1),
(32, 11, 20, 2),
(33, 11, 11, 3),
(34, 12, 21, 1),
(35, 12, 20, 2),
(36, 12, 22, 3),
(37, 13, 23, 1),
(38, 13, 24, 2),
(39, 13, 25, 3),
(40, 14, 21, 1),
(41, 14, 26, 2),
(42, 14, 24, 3),
(43, 15, 24, 1),
(44, 15, 27, 2),
(45, 15, 26, 3),
(46, 16, 24, 1),
(47, 16, 28, 2),
(48, 16, 26, 3),
(49, 17, 24, 1),
(50, 17, 28, 2),
(51, 17, 29, 3),
(52, 18, 30, 1),
(53, 18, 24, 2),
(54, 18, 31, 3),
(55, 19, 28, 1),
(56, 19, 32, 2),
(57, 19, 29, 3),
(58, 20, 32, 1),
(59, 20, 33, 2),
(60, 20, 34, 3),
(61, 21, 35, 1),
(62, 21, 36, 2),
(63, 21, 37, 3),
(64, 22, 36, 1),
(65, 22, 38, 2),
(66, 22, 39, 3),
(67, 23, 40, 1),
(68, 23, 41, 2),
(69, 23, 42, 3),
(70, 24, 43, 1),
(71, 24, 42, 2),
(72, 24, 44, 3),
(73, 25, 43, 1),
(74, 25, 38, 2),
(75, 25, 33, 3),
(76, 26, 45, 1),
(77, 26, 46, 2),
(78, 26, 47, 3),
(79, 27, 48, 1),
(80, 27, 49, 2),
(81, 27, 43, 3),
(82, 28, 50, 1),
(83, 28, 33, 2),
(84, 28, 47, 3),
(85, 29, 50, 1),
(86, 29, 51, 2),
(87, 29, 52, 3),
(88, 30, 53, 1),
(89, 30, 54, 2),
(90, 30, 55, 3),
(91, 31, 56, 1),
(92, 31, 57, 2),
(93, 31, 58, 3),
(94, 32, 57, 1),
(95, 32, 59, 2),
(96, 32, 56, 3),
(97, 33, 57, 1),
(98, 33, 56, 2),
(99, 33, 59, 3),
(100, 34, 60, 1),
(101, 34, 61, 2),
(102, 34, 52, 3),
(103, 35, 60, 1),
(104, 35, 62, 2),
(105, 35, 63, 3),
(106, 36, 56, 1),
(107, 36, 57, 2),
(108, 36, 64, 3),
(109, 37, 65, 1),
(110, 37, 56, 2),
(111, 37, 57, 2),
(112, 38, 66, 1),
(113, 38, 67, 2),
(114, 38, 57, 3),
(115, 39, 57, 1),
(116, 39, 68, 2),
(117, 39, 66, 3),
(118, 40, 69, 1),
(119, 40, 70, 2),
(120, 40, 71, 3),
(121, 41, 72, 1),
(122, 41, 73, 2),
(123, 41, 74, 3),
(124, 42, 75, 1),
(125, 42, 57, 2),
(126, 42, 72, 3),
(127, 43, 72, 1),
(128, 43, 76, 2),
(129, 43, 77, 3),
(130, 44, 57, 1),
(131, 44, 78, 2),
(132, 44, 79, 3),
(133, 45, 80, 1),
(134, 45, 72, 2),
(135, 45, 66, 3),
(136, 46, 76, 1),
(137, 46, 81, 2),
(138, 46, 77, 3),
(139, 47, 77, 1),
(140, 47, 73, 2),
(141, 47, 82, 3),
(142, 48, 83, 1),
(143, 48, 77, 2),
(144, 48, 84, 3),
(145, 49, 85, 1),
(146, 49, 77, 2),
(147, 49, 84, 3),
(148, 50, 81, 1),
(149, 50, 86, 2),
(150, 50, 70, 3),
(151, 51, 77, 1),
(152, 51, 81, 2),
(153, 51, 85, 3),
(154, 52, 87, 1),
(155, 52, 70, 2),
(156, 52, 88, 3),
(157, 53, 77, 1),
(158, 53, 70, 2),
(159, 53, 89, 3),
(160, 54, 77, 1),
(161, 54, 90, 1),
(162, 54, 91, 3),
(163, 55, 92, 1),
(164, 55, 93, 2),
(165, 55, 94, 2);

-- --------------------------------------------------------

--
-- Struktura tabeli dla  `zawodnik`
--

CREATE TABLE IF NOT EXISTS `zawodnik` (
  `zawodnik_id` int(11) NOT NULL AUTO_INCREMENT,
  `imie` varchar(45) COLLATE utf8_polish_ci DEFAULT NULL,
  `nazwisko` varchar(45) COLLATE utf8_polish_ci DEFAULT NULL,
  `panstwo_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`zawodnik_id`),
  KEY `fk_zawodnik_panstwo` (`panstwo_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci AUTO_INCREMENT=95 ;

--
-- Zrzut danych tabeli `zawodnik`
--

INSERT INTO `zawodnik` (`zawodnik_id`, `imie`, `nazwisko`, `panstwo_id`) VALUES
(1, 'Josef', 'Bradl', 1),
(2, 'Halvor', 'Naes', 2),
(3, 'Asgeir', 'Doelplads', 2),
(4, 'Olaf', 'Bjomstad', 2),
(5, 'Eino', 'Kirjonen', 3),
(6, 'Hemmo', 'Silvennoinen', 3),
(7, 'Aulis', 'Kallakorpi', 3),
(8, 'Nikołaj', 'Kamienski', 4),
(9, 'Nikołaj', 'Schamov', 4),
(10, 'Pentti', 'Uotinen', 3),
(11, 'Max', 'Bolkart', 5),
(12, 'Helmut', 'Recknagel', 6),
(13, 'Walter', 'Habersatter', 1),
(14, 'Arne', 'Hoel', 2),
(15, 'Albin', 'Plank', 1),
(16, 'Otto', 'Leodolter', 1),
(17, 'Kalevi', 'Kaerkkinen', 3),
(18, 'Willi', 'Egger', 1),
(19, 'Toralf', 'Engan', 2),
(20, 'Torbjorn', 'Yggeseth', 2),
(21, 'Veikko', 'Kankonnen', 3),
(22, 'Baldur', 'Preiml', 1),
(23, 'Torgeir', 'Brandtzaeg', 2),
(24, 'Bjorn', 'Wirkola', 2),
(25, 'Dalibor', 'Motejlek', 7),
(26, 'Dieter', 'Neuendorf', 5),
(27, 'Sepp', 'Lichtenegger', 1),
(28, 'Jiri', 'Raska', 7),
(29, 'Zbynek', 'Hubac', 7),
(30, 'Horst', 'Queck', 6),
(31, 'Gari', 'Napalkow', 4),
(32, 'Ingolf', 'Mork', 2),
(33, 'Henry', 'Glass', 6),
(34, 'Tauno', 'Kaeyhko', 3),
(35, 'Rainer', 'Schmidt', 6),
(36, 'Hans-Georg', 'Aschenbach', 6),
(37, 'Sergej', 'Botschkov', 4),
(38, 'Walter', 'Steiner', 8),
(39, 'Bernd', 'Eckstein', 6),
(40, 'Willi', 'Purstl', 1),
(41, 'Edi', 'Federer', 1),
(42, 'Karl', 'Schnabl', 1),
(43, 'Jochen', 'Danneberg', 6),
(44, 'Reinhold', 'Bachler', 1),
(45, 'Kari', 'Ylaanttila', 3),
(46, 'Mathias', 'Buse', 6),
(47, 'Martin', 'Weber', 6),
(48, 'Pentti', 'Kokkonen', 3),
(49, 'Hansjorg', 'Sumi', 8),
(50, 'Hubert', 'Neuper', 1),
(51, 'Armin', 'Kogler', 1),
(52, 'Jari', 'Puikkonen', 3),
(53, 'Manfred', 'Deckert', 6),
(54, 'Roger', 'Ruud', 2),
(55, 'Per', 'Bergerud', 2),
(56, 'Matti', 'Nykaenen', 3),
(57, 'Jens', 'Weissflog', 6),
(58, 'Horst', 'Bulau', 9),
(59, 'Klaus', 'Ostwald', 6),
(60, 'Ernst', 'Vettori', 1),
(61, 'Franz', 'Neulaendtner', 1),
(62, 'Vegard', 'Opaas', 2),
(63, 'Ulf', 'Findeisen', 6),
(64, 'Jiri', 'Parma', 7),
(65, 'Risto', 'Laakonen', 3),
(66, 'Dieter', 'Thoma', 5),
(67, 'Frantisek', 'Jez', 7),
(68, 'Andreas', 'Felder', 1),
(69, 'Toni', 'Nieminen', 3),
(70, 'Martin', 'Hoellwarth', 1),
(71, 'Werner', 'Rathmayr', 1),
(72, 'Andreas', 'Goldberger', 1),
(73, 'Noriaki', 'Kasai', 11),
(74, 'Jaroslav', 'Sakala', 12),
(75, 'Espen', 'Bredesen', 2),
(76, 'Kazuyoshi', 'Funaki', 11),
(77, 'Janne', 'Ahonen', 3),
(78, 'Ari-Pekka', 'Nikkola', 3),
(79, 'Reinhard', 'Schwarzenberger', 1),
(80, 'Primoz', 'Peterka', 13),
(81, 'Sven', 'Hannawald', 10),
(82, 'Hideharu', 'Miyahira', 11),
(83, 'Andreas', 'Widholzl', 1),
(84, 'Martin', 'Schmitt', 10),
(85, 'Adam', 'Małysz', 14),
(86, 'Matti', 'Hautamaki', 3),
(87, 'Sigurd', 'Pettersen', 2),
(88, 'Peter', 'Zonta', 13),
(89, 'Thomas', 'Morgenstern', 1),
(90, 'Jakub', 'Janda', 12),
(91, 'Roar', 'Ljokelsoy', 2),
(92, 'Anders', 'Jacobsen', 2),
(93, 'Gregor', 'Schlierenzauer', 1),
(94, 'Simon', 'Amman', 8);

--
-- Ograniczenia dla zrzutów tabel
--

--
-- Ograniczenia dla tabeli `sf_guard_group_permission`
--
ALTER TABLE `sf_guard_group_permission`
  ADD CONSTRAINT `sf_guard_group_permission_FK_1` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `sf_guard_group_permission_FK_2` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission` (`id`) ON DELETE CASCADE;

--
-- Ograniczenia dla tabeli `sf_guard_remember_key`
--
ALTER TABLE `sf_guard_remember_key`
  ADD CONSTRAINT `sf_guard_remember_key_FK_1` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE;

--
-- Ograniczenia dla tabeli `sf_guard_user_group`
--
ALTER TABLE `sf_guard_user_group`
  ADD CONSTRAINT `sf_guard_user_group_FK_1` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `sf_guard_user_group_FK_2` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group` (`id`) ON DELETE CASCADE;

--
-- Ograniczenia dla tabeli `sf_guard_user_permission`
--
ALTER TABLE `sf_guard_user_permission`
  ADD CONSTRAINT `sf_guard_user_permission_FK_1` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `sf_guard_user_permission_FK_2` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission` (`id`) ON DELETE CASCADE;

--
-- Ograniczenia dla tabeli `turniej_has_zawodnik`
--
ALTER TABLE `turniej_has_zawodnik`
  ADD CONSTRAINT `turniej_has_zawodnik_FK_1` FOREIGN KEY (`turniej_id`) REFERENCES `turniej` (`turniej_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `turniej_has_zawodnik_FK_2` FOREIGN KEY (`zawodnik_id`) REFERENCES `zawodnik` (`zawodnik_id`) ON DELETE CASCADE;

--
-- Ograniczenia dla tabeli `zawodnik`
--
ALTER TABLE `zawodnik`
  ADD CONSTRAINT `zawodnik_FK_1` FOREIGN KEY (`panstwo_id`) REFERENCES `panstwo` (`panstwo_id`) ON DELETE CASCADE;
