<?php

/**
 * Zawodnik form base class.
 *
 * @method Zawodnik getObject() Returns the current form's model object
 *
 * @package    tcs
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseZawodnikForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'zawodnik_id' => new sfWidgetFormInputHidden(),
      'imie'        => new sfWidgetFormInputText(),
      'nazwisko'    => new sfWidgetFormInputText(),
      'panstwo_id'  => new sfWidgetFormPropelChoice(array('model' => 'Panstwo', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'zawodnik_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getZawodnikId()), 'empty_value' => $this->getObject()->getZawodnikId(), 'required' => false)),
      'imie'        => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'nazwisko'    => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'panstwo_id'  => new sfValidatorPropelChoice(array('model' => 'Panstwo', 'column' => 'panstwo_id', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('zawodnik[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Zawodnik';
  }


}
