<?php

class propelImportdanychTask extends sfBaseTask
{
  protected function configure()
  {
    // // add your own arguments here
    // $this->addArguments(array(
    //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
    // ));

    $this->addOptions(array(
      new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
      new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
      new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
      // add your own options here
    ));

    $this->namespace        = 'propel';
    $this->name             = 'import-danych';
    $this->briefDescription = '';
    $this->detailedDescription = <<<EOF
The [propel:import-danych|INFO] task does things.
Call it with:

  [php symfony propel:import-danych|INFO]
EOF;
  }

  protected function execute($arguments = array(), $options = array())
  {
    // initialize the database connection
    $databaseManager = new sfDatabaseManager($this->configuration);
    $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

    // add your code here

    require_once 'lib/mimetypes.inc.php';

    PlikPeer::doDeleteAll();

    $plks = glob('data/download/*.*');
    foreach ($plks as $plk) {
        echo $plk . "\n";

        $path_parts = pathinfo($plk);

        $dane = array(
            'typmime' => get_mimetype_on_ext($path_parts['extension']),
            'dane'    => file_get_contents($plk),
            'slug'    => basename($plk)
        );

        $tmp = new Plik();
        $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
        $tmp->save();

    }


  }
}
