<?php

/**
 * ProjektHasCzcionka form base class.
 *
 * @method ProjektHasCzcionka getObject() Returns the current form's model object
 *
 * @package    zengardencss
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseProjektHasCzcionkaForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'projekt_id'  => new sfWidgetFormInputHidden(),
      'czcionka_id' => new sfWidgetFormInputHidden(),
    ));

    $this->setValidators(array(
      'projekt_id'  => new sfValidatorPropelChoice(array('model' => 'Projekt', 'column' => 'projekt_id', 'required' => false)),
      'czcionka_id' => new sfValidatorPropelChoice(array('model' => 'Czcionka', 'column' => 'czcionka_id', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('projekt_has_czcionka[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'ProjektHasCzcionka';
  }


}
