<?php

/**
 * Czcionka form base class.
 *
 * @method Czcionka getObject() Returns the current form's model object
 *
 * @package    zengardencss
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseCzcionkaForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'czcionka_id'               => new sfWidgetFormInputHidden(),
      'nazwa'                     => new sfWidgetFormInputText(),
      'podglad'                   => new sfWidgetFormInputText(),
      'liczbaprojektow'           => new sfWidgetFormInputText(),
      'slug'                      => new sfWidgetFormInputText(),
      'platforma_id'              => new sfWidgetFormInputText(),
      'rodzina_id'                => new sfWidgetFormPropelChoice(array('model' => 'Rodzina', 'add_empty' => true)),
      'projekt_has_czcionka_list' => new sfWidgetFormPropelChoice(array('multiple' => true, 'model' => 'Projekt')),
    ));

    $this->setValidators(array(
      'czcionka_id'               => new sfValidatorChoice(array('choices' => array($this->getObject()->getCzcionkaId()), 'empty_value' => $this->getObject()->getCzcionkaId(), 'required' => false)),
      'nazwa'                     => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'podglad'                   => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'liczbaprojektow'           => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'slug'                      => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'platforma_id'              => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'rodzina_id'                => new sfValidatorPropelChoice(array('model' => 'Rodzina', 'column' => 'rodzina_id', 'required' => false)),
      'projekt_has_czcionka_list' => new sfValidatorPropelChoice(array('multiple' => true, 'model' => 'Projekt', 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Czcionka', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('czcionka[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Czcionka';
  }


  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['projekt_has_czcionka_list']))
    {
      $values = array();
      foreach ($this->object->getProjektHasCzcionkas() as $obj)
      {
        $values[] = $obj->getProjektId();
      }

      $this->setDefault('projekt_has_czcionka_list', $values);
    }

  }

  protected function doSave($con = null)
  {
    parent::doSave($con);

    $this->saveProjektHasCzcionkaList($con);
  }

  public function saveProjektHasCzcionkaList($con = null)
  {
    if (!$this->isValid())
    {
      throw $this->getErrorSchema();
    }

    if (!isset($this->widgetSchema['projekt_has_czcionka_list']))
    {
      // somebody has unset this widget
      return;
    }

    if (null === $con)
    {
      $con = $this->getConnection();
    }

    $c = new Criteria();
    $c->add(ProjektHasCzcionkaPeer::CZCIONKA_ID, $this->object->getPrimaryKey());
    ProjektHasCzcionkaPeer::doDelete($c, $con);

    $values = $this->getValue('projekt_has_czcionka_list');
    if (is_array($values))
    {
      foreach ($values as $value)
      {
        $obj = new ProjektHasCzcionka();
        $obj->setCzcionkaId($this->object->getPrimaryKey());
        $obj->setProjektId($value);
        $obj->save();
      }
    }
  }

}
