<?php

/**
 * Panstwo filter form base class.
 *
 * @package    kontynenty
 * @subpackage filter
 * @author     Your name here
 */
abstract class BasePanstwoFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'nazwa'        => new sfWidgetFormFilterInput(),
      'slug'         => new sfWidgetFormFilterInput(),
      'kontynent_id' => new sfWidgetFormPropelChoice(array('model' => 'Kontynent', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'nazwa'        => new sfValidatorPass(array('required' => false)),
      'slug'         => new sfValidatorPass(array('required' => false)),
      'kontynent_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Kontynent', 'column' => 'kontynent_id')),
    ));

    $this->widgetSchema->setNameFormat('panstwo_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Panstwo';
  }

  public function getFields()
  {
    return array(
      'panstwo_id'   => 'Number',
      'nazwa'        => 'Text',
      'slug'         => 'Text',
      'kontynent_id' => 'ForeignKey',
    );
  }
}
