<?php

/**
 * Base class that represents a row from the 'przedmiot' table.
 *
 * 
 *
 * This class was autogenerated by Propel 1.4.2 on:
 *
 * 12/08/10 18:31:50
 *
 * @package    lib.model.om
 */
abstract class BasePrzedmiot extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        PrzedmiotPeer
	 */
	protected static $peer;

	/**
	 * The value for the przedmiot_id field.
	 * @var        int
	 */
	protected $przedmiot_id;

	/**
	 * The value for the nazwa field.
	 * @var        string
	 */
	protected $nazwa;

	/**
	 * The value for the skrot field.
	 * @var        string
	 */
	protected $skrot;

	/**
	 * The value for the godz field.
	 * @var        int
	 */
	protected $godz;

	/**
	 * The value for the zal field.
	 * @var        string
	 */
	protected $zal;

	/**
	 * The value for the liczbagrup field.
	 * @var        int
	 */
	protected $liczbagrup;

	/**
	 * The value for the semestr field.
	 * @var        int
	 */
	protected $semestr;

	/**
	 * The value for the rok field.
	 * @var        int
	 */
	protected $rok;

	/**
	 * The value for the odbywa_sie field.
	 * @var        int
	 */
	protected $odbywa_sie;

	/**
	 * The value for the nazwa_alternatywna field.
	 * @var        string
	 */
	protected $nazwa_alternatywna;

	/**
	 * The value for the zimalato field.
	 * @var        int
	 */
	protected $zimalato;

	/**
	 * The value for the rodzajzajec_id field.
	 * @var        int
	 */
	protected $rodzajzajec_id;

	/**
	 * The value for the kierunek_id field.
	 * @var        int
	 */
	protected $kierunek_id;

	/**
	 * The value for the slug field.
	 * @var        string
	 */
	protected $slug;

	/**
	 * @var        Rodzajzajec
	 */
	protected $aRodzajzajec;

	/**
	 * @var        Kierunek
	 */
	protected $aKierunek;

	/**
	 * @var        array Przydzial[] Collection to store aggregation of Przydzial objects.
	 */
	protected $collPrzydzials;

	/**
	 * @var        Criteria The criteria used to select the current contents of collPrzydzials.
	 */
	private $lastPrzydzialCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	// symfony behavior
	
	const PEER = 'PrzedmiotPeer';

	/**
	 * Get the [przedmiot_id] column value.
	 * 
	 * @return     int
	 */
	public function getPrzedmiotId()
	{
		return $this->przedmiot_id;
	}

	/**
	 * Get the [nazwa] column value.
	 * 
	 * @return     string
	 */
	public function getNazwa()
	{
		return $this->nazwa;
	}

	/**
	 * Get the [skrot] column value.
	 * 
	 * @return     string
	 */
	public function getSkrot()
	{
		return $this->skrot;
	}

	/**
	 * Get the [godz] column value.
	 * 
	 * @return     int
	 */
	public function getGodz()
	{
		return $this->godz;
	}

	/**
	 * Get the [zal] column value.
	 * 
	 * @return     string
	 */
	public function getZal()
	{
		return $this->zal;
	}

	/**
	 * Get the [liczbagrup] column value.
	 * 
	 * @return     int
	 */
	public function getLiczbagrup()
	{
		return $this->liczbagrup;
	}

	/**
	 * Get the [semestr] column value.
	 * 
	 * @return     int
	 */
	public function getSemestr()
	{
		return $this->semestr;
	}

	/**
	 * Get the [rok] column value.
	 * 
	 * @return     int
	 */
	public function getRok()
	{
		return $this->rok;
	}

	/**
	 * Get the [odbywa_sie] column value.
	 * 
	 * @return     int
	 */
	public function getOdbywaSie()
	{
		return $this->odbywa_sie;
	}

	/**
	 * Get the [nazwa_alternatywna] column value.
	 * 
	 * @return     string
	 */
	public function getNazwaAlternatywna()
	{
		return $this->nazwa_alternatywna;
	}

	/**
	 * Get the [zimalato] column value.
	 * 
	 * @return     int
	 */
	public function getZimalato()
	{
		return $this->zimalato;
	}

	/**
	 * Get the [rodzajzajec_id] column value.
	 * 
	 * @return     int
	 */
	public function getRodzajzajecId()
	{
		return $this->rodzajzajec_id;
	}

	/**
	 * Get the [kierunek_id] column value.
	 * 
	 * @return     int
	 */
	public function getKierunekId()
	{
		return $this->kierunek_id;
	}

	/**
	 * Get the [slug] column value.
	 * 
	 * @return     string
	 */
	public function getSlug()
	{
		return $this->slug;
	}

	/**
	 * Set the value of [przedmiot_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setPrzedmiotId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->przedmiot_id !== $v) {
			$this->przedmiot_id = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::PRZEDMIOT_ID;
		}

		return $this;
	} // setPrzedmiotId()

	/**
	 * Set the value of [nazwa] column.
	 * 
	 * @param      string $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setNazwa($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->nazwa !== $v) {
			$this->nazwa = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::NAZWA;
		}

		return $this;
	} // setNazwa()

	/**
	 * Set the value of [skrot] column.
	 * 
	 * @param      string $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setSkrot($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->skrot !== $v) {
			$this->skrot = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::SKROT;
		}

		return $this;
	} // setSkrot()

	/**
	 * Set the value of [godz] column.
	 * 
	 * @param      int $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setGodz($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->godz !== $v) {
			$this->godz = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::GODZ;
		}

		return $this;
	} // setGodz()

	/**
	 * Set the value of [zal] column.
	 * 
	 * @param      string $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setZal($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->zal !== $v) {
			$this->zal = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::ZAL;
		}

		return $this;
	} // setZal()

	/**
	 * Set the value of [liczbagrup] column.
	 * 
	 * @param      int $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setLiczbagrup($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->liczbagrup !== $v) {
			$this->liczbagrup = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::LICZBAGRUP;
		}

		return $this;
	} // setLiczbagrup()

	/**
	 * Set the value of [semestr] column.
	 * 
	 * @param      int $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setSemestr($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->semestr !== $v) {
			$this->semestr = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::SEMESTR;
		}

		return $this;
	} // setSemestr()

	/**
	 * Set the value of [rok] column.
	 * 
	 * @param      int $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setRok($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->rok !== $v) {
			$this->rok = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::ROK;
		}

		return $this;
	} // setRok()

	/**
	 * Set the value of [odbywa_sie] column.
	 * 
	 * @param      int $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setOdbywaSie($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->odbywa_sie !== $v) {
			$this->odbywa_sie = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::ODBYWA_SIE;
		}

		return $this;
	} // setOdbywaSie()

	/**
	 * Set the value of [nazwa_alternatywna] column.
	 * 
	 * @param      string $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setNazwaAlternatywna($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->nazwa_alternatywna !== $v) {
			$this->nazwa_alternatywna = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::NAZWA_ALTERNATYWNA;
		}

		return $this;
	} // setNazwaAlternatywna()

	/**
	 * Set the value of [zimalato] column.
	 * 
	 * @param      int $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setZimalato($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->zimalato !== $v) {
			$this->zimalato = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::ZIMALATO;
		}

		return $this;
	} // setZimalato()

	/**
	 * Set the value of [rodzajzajec_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setRodzajzajecId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->rodzajzajec_id !== $v) {
			$this->rodzajzajec_id = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::RODZAJZAJEC_ID;
		}

		if ($this->aRodzajzajec !== null && $this->aRodzajzajec->getRodzajzajecId() !== $v) {
			$this->aRodzajzajec = null;
		}

		return $this;
	} // setRodzajzajecId()

	/**
	 * Set the value of [kierunek_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setKierunekId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->kierunek_id !== $v) {
			$this->kierunek_id = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::KIERUNEK_ID;
		}

		if ($this->aKierunek !== null && $this->aKierunek->getKierunekId() !== $v) {
			$this->aKierunek = null;
		}

		return $this;
	} // setKierunekId()

	/**
	 * Set the value of [slug] column.
	 * 
	 * @param      string $v new value
	 * @return     Przedmiot The current object (for fluent API support)
	 */
	public function setSlug($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->slug !== $v) {
			$this->slug = $v;
			$this->modifiedColumns[] = PrzedmiotPeer::SLUG;
		}

		return $this;
	} // setSlug()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->przedmiot_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->nazwa = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->skrot = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->godz = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
			$this->zal = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
			$this->liczbagrup = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
			$this->semestr = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
			$this->rok = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
			$this->odbywa_sie = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
			$this->nazwa_alternatywna = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
			$this->zimalato = ($row[$startcol + 10] !== null) ? (int) $row[$startcol + 10] : null;
			$this->rodzajzajec_id = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
			$this->kierunek_id = ($row[$startcol + 12] !== null) ? (int) $row[$startcol + 12] : null;
			$this->slug = ($row[$startcol + 13] !== null) ? (string) $row[$startcol + 13] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 14; // 14 = PrzedmiotPeer::NUM_COLUMNS - PrzedmiotPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Przedmiot object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

		if ($this->aRodzajzajec !== null && $this->rodzajzajec_id !== $this->aRodzajzajec->getRodzajzajecId()) {
			$this->aRodzajzajec = null;
		}
		if ($this->aKierunek !== null && $this->kierunek_id !== $this->aKierunek->getKierunekId()) {
			$this->aKierunek = null;
		}
	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PrzedmiotPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = PrzedmiotPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->aRodzajzajec = null;
			$this->aKierunek = null;
			$this->collPrzydzials = null;
			$this->lastPrzydzialCriteria = null;

		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PrzedmiotPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$ret = $this->preDelete($con);
			// symfony_behaviors behavior
			foreach (sfMixer::getCallables('BasePrzedmiot:delete:pre') as $callable)
			{
			  if (call_user_func($callable, $this, $con))
			  {
			    $con->commit();
			
			    return;
			  }
			}

			if ($ret) {
				PrzedmiotPeer::doDelete($this, $con);
				$this->postDelete($con);
				// symfony_behaviors behavior
				foreach (sfMixer::getCallables('BasePrzedmiot:delete:post') as $callable)
				{
				  call_user_func($callable, $this, $con);
				}

				$this->setDeleted(true);
				$con->commit();
			} else {
				$con->commit();
			}
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PrzedmiotPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		$isInsert = $this->isNew();
		try {
			$ret = $this->preSave($con);
			// symfony_behaviors behavior
			foreach (sfMixer::getCallables('BasePrzedmiot:save:pre') as $callable)
			{
			  if (is_integer($affectedRows = call_user_func($callable, $this, $con)))
			  {
			    $con->commit();
			
			    return $affectedRows;
			  }
			}

			if ($isInsert) {
				$ret = $ret && $this->preInsert($con);
			} else {
				$ret = $ret && $this->preUpdate($con);
			}
			if ($ret) {
				$affectedRows = $this->doSave($con);
				if ($isInsert) {
					$this->postInsert($con);
				} else {
					$this->postUpdate($con);
				}
				$this->postSave($con);
				// symfony_behaviors behavior
				foreach (sfMixer::getCallables('BasePrzedmiot:save:post') as $callable)
				{
				  call_user_func($callable, $this, $con, $affectedRows);
				}

				PrzedmiotPeer::addInstanceToPool($this);
			} else {
				$affectedRows = 0;
			}
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aRodzajzajec !== null) {
				if ($this->aRodzajzajec->isModified() || $this->aRodzajzajec->isNew()) {
					$affectedRows += $this->aRodzajzajec->save($con);
				}
				$this->setRodzajzajec($this->aRodzajzajec);
			}

			if ($this->aKierunek !== null) {
				if ($this->aKierunek->isModified() || $this->aKierunek->isNew()) {
					$affectedRows += $this->aKierunek->save($con);
				}
				$this->setKierunek($this->aKierunek);
			}

			if ($this->isNew() ) {
				$this->modifiedColumns[] = PrzedmiotPeer::PRZEDMIOT_ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = PrzedmiotPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setPrzedmiotId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += PrzedmiotPeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collPrzydzials !== null) {
				foreach ($this->collPrzydzials as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aRodzajzajec !== null) {
				if (!$this->aRodzajzajec->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aRodzajzajec->getValidationFailures());
				}
			}

			if ($this->aKierunek !== null) {
				if (!$this->aKierunek->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aKierunek->getValidationFailures());
				}
			}


			if (($retval = PrzedmiotPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collPrzydzials !== null) {
					foreach ($this->collPrzydzials as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PrzedmiotPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getPrzedmiotId();
				break;
			case 1:
				return $this->getNazwa();
				break;
			case 2:
				return $this->getSkrot();
				break;
			case 3:
				return $this->getGodz();
				break;
			case 4:
				return $this->getZal();
				break;
			case 5:
				return $this->getLiczbagrup();
				break;
			case 6:
				return $this->getSemestr();
				break;
			case 7:
				return $this->getRok();
				break;
			case 8:
				return $this->getOdbywaSie();
				break;
			case 9:
				return $this->getNazwaAlternatywna();
				break;
			case 10:
				return $this->getZimalato();
				break;
			case 11:
				return $this->getRodzajzajecId();
				break;
			case 12:
				return $this->getKierunekId();
				break;
			case 13:
				return $this->getSlug();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = PrzedmiotPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getPrzedmiotId(),
			$keys[1] => $this->getNazwa(),
			$keys[2] => $this->getSkrot(),
			$keys[3] => $this->getGodz(),
			$keys[4] => $this->getZal(),
			$keys[5] => $this->getLiczbagrup(),
			$keys[6] => $this->getSemestr(),
			$keys[7] => $this->getRok(),
			$keys[8] => $this->getOdbywaSie(),
			$keys[9] => $this->getNazwaAlternatywna(),
			$keys[10] => $this->getZimalato(),
			$keys[11] => $this->getRodzajzajecId(),
			$keys[12] => $this->getKierunekId(),
			$keys[13] => $this->getSlug(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PrzedmiotPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setPrzedmiotId($value);
				break;
			case 1:
				$this->setNazwa($value);
				break;
			case 2:
				$this->setSkrot($value);
				break;
			case 3:
				$this->setGodz($value);
				break;
			case 4:
				$this->setZal($value);
				break;
			case 5:
				$this->setLiczbagrup($value);
				break;
			case 6:
				$this->setSemestr($value);
				break;
			case 7:
				$this->setRok($value);
				break;
			case 8:
				$this->setOdbywaSie($value);
				break;
			case 9:
				$this->setNazwaAlternatywna($value);
				break;
			case 10:
				$this->setZimalato($value);
				break;
			case 11:
				$this->setRodzajzajecId($value);
				break;
			case 12:
				$this->setKierunekId($value);
				break;
			case 13:
				$this->setSlug($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = PrzedmiotPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setPrzedmiotId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setNazwa($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setSkrot($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setGodz($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setZal($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setLiczbagrup($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setSemestr($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setRok($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setOdbywaSie($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setNazwaAlternatywna($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setZimalato($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setRodzajzajecId($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setKierunekId($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setSlug($arr[$keys[13]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(PrzedmiotPeer::DATABASE_NAME);

		if ($this->isColumnModified(PrzedmiotPeer::PRZEDMIOT_ID)) $criteria->add(PrzedmiotPeer::PRZEDMIOT_ID, $this->przedmiot_id);
		if ($this->isColumnModified(PrzedmiotPeer::NAZWA)) $criteria->add(PrzedmiotPeer::NAZWA, $this->nazwa);
		if ($this->isColumnModified(PrzedmiotPeer::SKROT)) $criteria->add(PrzedmiotPeer::SKROT, $this->skrot);
		if ($this->isColumnModified(PrzedmiotPeer::GODZ)) $criteria->add(PrzedmiotPeer::GODZ, $this->godz);
		if ($this->isColumnModified(PrzedmiotPeer::ZAL)) $criteria->add(PrzedmiotPeer::ZAL, $this->zal);
		if ($this->isColumnModified(PrzedmiotPeer::LICZBAGRUP)) $criteria->add(PrzedmiotPeer::LICZBAGRUP, $this->liczbagrup);
		if ($this->isColumnModified(PrzedmiotPeer::SEMESTR)) $criteria->add(PrzedmiotPeer::SEMESTR, $this->semestr);
		if ($this->isColumnModified(PrzedmiotPeer::ROK)) $criteria->add(PrzedmiotPeer::ROK, $this->rok);
		if ($this->isColumnModified(PrzedmiotPeer::ODBYWA_SIE)) $criteria->add(PrzedmiotPeer::ODBYWA_SIE, $this->odbywa_sie);
		if ($this->isColumnModified(PrzedmiotPeer::NAZWA_ALTERNATYWNA)) $criteria->add(PrzedmiotPeer::NAZWA_ALTERNATYWNA, $this->nazwa_alternatywna);
		if ($this->isColumnModified(PrzedmiotPeer::ZIMALATO)) $criteria->add(PrzedmiotPeer::ZIMALATO, $this->zimalato);
		if ($this->isColumnModified(PrzedmiotPeer::RODZAJZAJEC_ID)) $criteria->add(PrzedmiotPeer::RODZAJZAJEC_ID, $this->rodzajzajec_id);
		if ($this->isColumnModified(PrzedmiotPeer::KIERUNEK_ID)) $criteria->add(PrzedmiotPeer::KIERUNEK_ID, $this->kierunek_id);
		if ($this->isColumnModified(PrzedmiotPeer::SLUG)) $criteria->add(PrzedmiotPeer::SLUG, $this->slug);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(PrzedmiotPeer::DATABASE_NAME);

		$criteria->add(PrzedmiotPeer::PRZEDMIOT_ID, $this->przedmiot_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getPrzedmiotId();
	}

	/**
	 * Generic method to set the primary key (przedmiot_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setPrzedmiotId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Przedmiot (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setNazwa($this->nazwa);

		$copyObj->setSkrot($this->skrot);

		$copyObj->setGodz($this->godz);

		$copyObj->setZal($this->zal);

		$copyObj->setLiczbagrup($this->liczbagrup);

		$copyObj->setSemestr($this->semestr);

		$copyObj->setRok($this->rok);

		$copyObj->setOdbywaSie($this->odbywa_sie);

		$copyObj->setNazwaAlternatywna($this->nazwa_alternatywna);

		$copyObj->setZimalato($this->zimalato);

		$copyObj->setRodzajzajecId($this->rodzajzajec_id);

		$copyObj->setKierunekId($this->kierunek_id);

		$copyObj->setSlug($this->slug);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getPrzydzials() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addPrzydzial($relObj->copy($deepCopy));
				}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setPrzedmiotId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Przedmiot Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     PrzedmiotPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new PrzedmiotPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a Rodzajzajec object.
	 *
	 * @param      Rodzajzajec $v
	 * @return     Przedmiot The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setRodzajzajec(Rodzajzajec $v = null)
	{
		if ($v === null) {
			$this->setRodzajzajecId(NULL);
		} else {
			$this->setRodzajzajecId($v->getRodzajzajecId());
		}

		$this->aRodzajzajec = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Rodzajzajec object, it will not be re-added.
		if ($v !== null) {
			$v->addPrzedmiot($this);
		}

		return $this;
	}


	/**
	 * Get the associated Rodzajzajec object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Rodzajzajec The associated Rodzajzajec object.
	 * @throws     PropelException
	 */
	public function getRodzajzajec(PropelPDO $con = null)
	{
		if ($this->aRodzajzajec === null && ($this->rodzajzajec_id !== null)) {
			$this->aRodzajzajec = RodzajzajecPeer::retrieveByPk($this->rodzajzajec_id);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aRodzajzajec->addPrzedmiots($this);
			 */
		}
		return $this->aRodzajzajec;
	}

	/**
	 * Declares an association between this object and a Kierunek object.
	 *
	 * @param      Kierunek $v
	 * @return     Przedmiot The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setKierunek(Kierunek $v = null)
	{
		if ($v === null) {
			$this->setKierunekId(NULL);
		} else {
			$this->setKierunekId($v->getKierunekId());
		}

		$this->aKierunek = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Kierunek object, it will not be re-added.
		if ($v !== null) {
			$v->addPrzedmiot($this);
		}

		return $this;
	}


	/**
	 * Get the associated Kierunek object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Kierunek The associated Kierunek object.
	 * @throws     PropelException
	 */
	public function getKierunek(PropelPDO $con = null)
	{
		if ($this->aKierunek === null && ($this->kierunek_id !== null)) {
			$this->aKierunek = KierunekPeer::retrieveByPk($this->kierunek_id);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aKierunek->addPrzedmiots($this);
			 */
		}
		return $this->aKierunek;
	}

	/**
	 * Clears out the collPrzydzials collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addPrzydzials()
	 */
	public function clearPrzydzials()
	{
		$this->collPrzydzials = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collPrzydzials collection (array).
	 *
	 * By default this just sets the collPrzydzials collection to an empty array (like clearcollPrzydzials());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initPrzydzials()
	{
		$this->collPrzydzials = array();
	}

	/**
	 * Gets an array of Przydzial objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Przedmiot has previously been saved, it will retrieve
	 * related Przydzials from storage. If this Przedmiot is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array Przydzial[]
	 * @throws     PropelException
	 */
	public function getPrzydzials($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PrzedmiotPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPrzydzials === null) {
			if ($this->isNew()) {
			   $this->collPrzydzials = array();
			} else {

				$criteria->add(PrzydzialPeer::PRZEDMIOT_ID, $this->przedmiot_id);

				PrzydzialPeer::addSelectColumns($criteria);
				$this->collPrzydzials = PrzydzialPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(PrzydzialPeer::PRZEDMIOT_ID, $this->przedmiot_id);

				PrzydzialPeer::addSelectColumns($criteria);
				if (!isset($this->lastPrzydzialCriteria) || !$this->lastPrzydzialCriteria->equals($criteria)) {
					$this->collPrzydzials = PrzydzialPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPrzydzialCriteria = $criteria;
		return $this->collPrzydzials;
	}

	/**
	 * Returns the number of related Przydzial objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related Przydzial objects.
	 * @throws     PropelException
	 */
	public function countPrzydzials(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PrzedmiotPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collPrzydzials === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(PrzydzialPeer::PRZEDMIOT_ID, $this->przedmiot_id);

				$count = PrzydzialPeer::doCount($criteria, false, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(PrzydzialPeer::PRZEDMIOT_ID, $this->przedmiot_id);

				if (!isset($this->lastPrzydzialCriteria) || !$this->lastPrzydzialCriteria->equals($criteria)) {
					$count = PrzydzialPeer::doCount($criteria, false, $con);
				} else {
					$count = count($this->collPrzydzials);
				}
			} else {
				$count = count($this->collPrzydzials);
			}
		}
		return $count;
	}

	/**
	 * Method called to associate a Przydzial object to this object
	 * through the Przydzial foreign key attribute.
	 *
	 * @param      Przydzial $l Przydzial
	 * @return     void
	 * @throws     PropelException
	 */
	public function addPrzydzial(Przydzial $l)
	{
		if ($this->collPrzydzials === null) {
			$this->initPrzydzials();
		}
		if (!in_array($l, $this->collPrzydzials, true)) { // only add it if the **same** object is not already associated
			array_push($this->collPrzydzials, $l);
			$l->setPrzedmiot($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Przedmiot is new, it will return
	 * an empty collection; or if this Przedmiot has previously
	 * been saved, it will retrieve related Przydzials from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Przedmiot.
	 */
	public function getPrzydzialsJoinPracownik($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PrzedmiotPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPrzydzials === null) {
			if ($this->isNew()) {
				$this->collPrzydzials = array();
			} else {

				$criteria->add(PrzydzialPeer::PRZEDMIOT_ID, $this->przedmiot_id);

				$this->collPrzydzials = PrzydzialPeer::doSelectJoinPracownik($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(PrzydzialPeer::PRZEDMIOT_ID, $this->przedmiot_id);

			if (!isset($this->lastPrzydzialCriteria) || !$this->lastPrzydzialCriteria->equals($criteria)) {
				$this->collPrzydzials = PrzydzialPeer::doSelectJoinPracownik($criteria, $con, $join_behavior);
			}
		}
		$this->lastPrzydzialCriteria = $criteria;

		return $this->collPrzydzials;
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
			if ($this->collPrzydzials) {
				foreach ((array) $this->collPrzydzials as $o) {
					$o->clearAllReferences($deep);
				}
			}
		} // if ($deep)

		$this->collPrzydzials = null;
			$this->aRodzajzajec = null;
			$this->aKierunek = null;
	}

	// symfony_behaviors behavior
	
	/**
	 * Calls methods defined via {@link sfMixer}.
	 */
	public function __call($method, $arguments)
	{
	  if (!$callable = sfMixer::getCallable('BasePrzedmiot:'.$method))
	  {
	    throw new sfException(sprintf('Call to undefined method BasePrzedmiot::%s', $method));
	  }
	
	  array_unshift($arguments, $this);
	
	  return call_user_func_array($callable, $arguments);
	}

	/**
	 * Return the string representation of this object
	 *
	 * @return string The value of the 'skrot' column
	 */
  public function __toString()
  {
    return (string) $this->getSkrot();
  }

} // BasePrzedmiot
