<?php

/**
 * Skeleton subclass for representing a row from the 'kierunek' table.
 *
 * 
 *
 * This class was autogenerated by Propel 1.4.2 on:
 *
 * 09/27/10 10:49:41
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    lib.model
 */
class Kierunek extends BaseKierunek
{

    function przedmiotySemestru($semestr)
    {
        $c = new Criteria();
        $c->add(PrzedmiotPeer::SEMESTR, $semestr);
        return self::getPrzedmiots($c);
    }

    function obsadaKierunku()
    {
        $obsadaKierunku = array();
        for ($i = 1; $i <= $this->getRodzajstudiow()->getLata(); $i++) {
            $rok = $i;
            $semestrZima = round($rok * 2 - 1);
            $semestrLato = round($rok * 2);

            $przedmiotySemestruZima = $this->przedmiotySemestru($semestrZima);
            $przedmiotySemestruLato = $this->przedmiotySemestru($semestrLato);

            $obsadaKierunku[] = array(
                'rok' => $rok,
                'semestrZima' => $semestrZima,
                'semestrLato' => $semestrLato,
                'przedmiotySemestruZima' => $przedmiotySemestruZima,
                'przedmiotySemestruLato' => $przedmiotySemestruLato,
            );
        }
        return $obsadaKierunku;
    }

    public function isValidSemestr($semestr)
    {
        return myString::str_ievpifr($semestr, 1, $this->getRodzajstudiow()->getSemestry());
    }

    public function isValidRok($rok)
    {
        return myString::str_ievpifr($rok, 1, $this->getRodzajstudiow()->getLata());
    }


}

// Kierunek
