<?php

/**
 * Stanowisko form base class.
 *
 * @method Stanowisko getObject() Returns the current form's model object
 *
 * @package    angaze
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseStanowiskoForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'stanowisko_id' => new sfWidgetFormInputHidden(),
      'nazwa'         => new sfWidgetFormInputText(),
      'skrot'         => new sfWidgetFormInputText(),
      'pensum'        => new sfWidgetFormInputText(),
      'sortowanie'    => new sfWidgetFormInputText(),
      'slug'          => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'stanowisko_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getStanowiskoId()), 'empty_value' => $this->getObject()->getStanowiskoId(), 'required' => false)),
      'nazwa'         => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'skrot'         => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'pensum'        => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'sortowanie'    => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'slug'          => new sfValidatorString(array('max_length' => 128)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Stanowisko', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('stanowisko[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Stanowisko';
  }


}
