<?php

/**
 * Pracownik form base class.
 *
 * @method Pracownik getObject() Returns the current form's model object
 *
 * @package    angaze
 * @subpackage form
 * @author     Your name here
 */
abstract class BasePracownikForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'pracownik_id'  => new sfWidgetFormInputHidden(),
      'imie'          => new sfWidgetFormInputText(),
      'nazwisko'      => new sfWidgetFormInputText(),
      'skrot'         => new sfWidgetFormInputText(),
      'tytul'         => new sfWidgetFormInputText(),
      'pokoj_id'      => new sfWidgetFormPropelChoice(array('model' => 'Pokoj', 'add_empty' => true)),
      'stanowisko_id' => new sfWidgetFormPropelChoice(array('model' => 'Stanowisko', 'add_empty' => true)),
      'katedra_id'    => new sfWidgetFormPropelChoice(array('model' => 'Katedra', 'add_empty' => true)),
      'slug'          => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'pracownik_id'  => new sfValidatorChoice(array('choices' => array($this->getObject()->getPracownikId()), 'empty_value' => $this->getObject()->getPracownikId(), 'required' => false)),
      'imie'          => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'nazwisko'      => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'skrot'         => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'tytul'         => new sfValidatorString(array('max_length' => 20, 'required' => false)),
      'pokoj_id'      => new sfValidatorPropelChoice(array('model' => 'Pokoj', 'column' => 'pokoj_id', 'required' => false)),
      'stanowisko_id' => new sfValidatorPropelChoice(array('model' => 'Stanowisko', 'column' => 'stanowisko_id', 'required' => false)),
      'katedra_id'    => new sfValidatorPropelChoice(array('model' => 'Katedra', 'column' => 'katedra_id', 'required' => false)),
      'slug'          => new sfValidatorString(array('max_length' => 128)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Pracownik', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('pracownik[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Pracownik';
  }


}
