<?php

/**
 * Pracownik filter form base class.
 *
 * @package    angaze
 * @subpackage filter
 * @author     Your name here
 */
abstract class BasePracownikFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'imie'          => new sfWidgetFormFilterInput(),
      'nazwisko'      => new sfWidgetFormFilterInput(),
      'skrot'         => new sfWidgetFormFilterInput(),
      'tytul'         => new sfWidgetFormFilterInput(),
      'pokoj_id'      => new sfWidgetFormPropelChoice(array('model' => 'Pokoj', 'add_empty' => true)),
      'stanowisko_id' => new sfWidgetFormPropelChoice(array('model' => 'Stanowisko', 'add_empty' => true)),
      'katedra_id'    => new sfWidgetFormPropelChoice(array('model' => 'Katedra', 'add_empty' => true)),
      'slug'          => new sfWidgetFormFilterInput(array('with_empty' => false)),
    ));

    $this->setValidators(array(
      'imie'          => new sfValidatorPass(array('required' => false)),
      'nazwisko'      => new sfValidatorPass(array('required' => false)),
      'skrot'         => new sfValidatorPass(array('required' => false)),
      'tytul'         => new sfValidatorPass(array('required' => false)),
      'pokoj_id'      => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Pokoj', 'column' => 'pokoj_id')),
      'stanowisko_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Stanowisko', 'column' => 'stanowisko_id')),
      'katedra_id'    => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Katedra', 'column' => 'katedra_id')),
      'slug'          => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('pracownik_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Pracownik';
  }

  public function getFields()
  {
    return array(
      'pracownik_id'  => 'Number',
      'imie'          => 'Text',
      'nazwisko'      => 'Text',
      'skrot'         => 'Text',
      'tytul'         => 'Text',
      'pokoj_id'      => 'ForeignKey',
      'stanowisko_id' => 'ForeignKey',
      'katedra_id'    => 'ForeignKey',
      'slug'          => 'Text',
    );
  }
}
