<?php

/**
 * Skrot form base class.
 *
 * @method Skrot getObject() Returns the current form's model object
 *
 * @package    noth
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseSkrotForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'skrot_id' => new sfWidgetFormInputHidden(),
      'skrot'    => new sfWidgetFormInputText(),
      'opis'     => new sfWidgetFormInputText(),
      'kod'      => new sfWidgetFormInputText(),
      'grupa_id' => new sfWidgetFormPropelChoice(array('model' => 'Grupa', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'skrot_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getSkrotId()), 'empty_value' => $this->getObject()->getSkrotId(), 'required' => false)),
      'skrot'    => new sfValidatorString(array('max_length' => 2, 'required' => false)),
      'opis'     => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'kod'      => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'grupa_id' => new sfValidatorPropelChoice(array('model' => 'Grupa', 'column' => 'grupa_id', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('skrot[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Skrot';
  }


}
