<?php

/**
 * Szczyt form base class.
 *
 * @method Szczyt getObject() Returns the current form's model object
 *
 * @package    tatry
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseSzczytForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'szczyt_id' => new sfWidgetFormInputHidden(),
      'nazwa'     => new sfWidgetFormInputText(),
      'wysokosc'  => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'szczyt_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getSzczytId()), 'empty_value' => $this->getObject()->getSzczytId(), 'required' => false)),
      'nazwa'     => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'wysokosc'  => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('szczyt[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Szczyt';
  }


}
