<?php

/**
 * Skeleton subclass for representing a row from the 'rozdzial' table.
 *
 * 
 *
 * This class was autogenerated by Propel 1.4.2 on:
 *
 * 08/31/10 12:16:28
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    lib.model
 */

class Rozdzial extends BaseRozdzial {

    public function setSlug($slug) {
        $slug = trim($slug);

        if ($slug == '') {
            $slug = myString::string2slug($this->getTytul());
        } else {
            $slug = myString::string2slug($slug);
        }

        $next_slug = $slug;
        $c = new Criteria();
        $c->add(RozdzialPeer::SLUG, $next_slug);
        $c->add(RozdzialPeer::ROZDZIAL_ID, $this->getRozdzialId(), Criteria::NOT_EQUAL);
        $ile = RozdzialPeer::doCount($c);

        $unikatowy = ($ile == 0);

        $min = 2;
        $max = 1000;

        while (!$unikatowy) {

            $next_slug = $slug . '__' . $min;
            $min++;

            if ($min > $max + 1) {
                die("****** ERROR    RozdzialPeer::setSlug({$next_slug})");
            };

            $c->clear();
            $c->add(RozdzialPeer::SLUG, $next_slug);
            $c->add(RozdzialPeer::ROZDZIAL_ID, $this->getRozdzialId(), Criteria::NOT_EQUAL);
            $ile = RozdzialPeer::doCount($c);
            $unikatowy = ($ile == 0);
        }

        parent::setSlug($next_slug);
    }

    public function getMaxNumerZadania() {
        $c = new Criteria();
        $c->addDescendingOrderByColumn(ZadaniePeer::NUMER);
        $c->add(ZadaniePeer::ROZDZIAL_ID, $this->getRozdzialId());
        $c->setLimit(1);
        $Zadanie = ZadaniePeer::doSelectOne($c);
        if ($Zadanie) {
            return $Zadanie->getNumer();
        } else {
            return 0;
        }
    }

}

// Rozdzial
