
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- rozdzial
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rozdzial`;


CREATE TABLE `rozdzial`
(
	`rozdzial_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(128),
	`slug` VARCHAR(128),
	`numer` INTEGER,
	PRIMARY KEY (`rozdzial_id`),
	UNIQUE KEY `u_numer` (`numer`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- zadanie
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `zadanie`;


CREATE TABLE `zadanie`
(
	`zadanie_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`numer` INTEGER,
	`slug` VARCHAR(45),
	`tresc` TEXT,
	`odpowiedz` TEXT,
	`rozdzial_id` INTEGER  NOT NULL,
	PRIMARY KEY (`zadanie_id`),
	KEY `fk_zadanie_rozdzial`(`rozdzial_id`),
	CONSTRAINT `zadanie_FK_1`
		FOREIGN KEY (`rozdzial_id`)
		REFERENCES `rozdzial` (`rozdzial_id`)
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
