<?php

/**
 * FilmHasAktor form base class.
 *
 * @method FilmHasAktor getObject() Returns the current form's model object
 *
 * @package    filmy
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseFilmHasAktorForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'film_id'  => new sfWidgetFormInputHidden(),
      'aktor_id' => new sfWidgetFormInputHidden(),
    ));

    $this->setValidators(array(
      'film_id'  => new sfValidatorPropelChoice(array('model' => 'Film', 'column' => 'film_id', 'required' => false)),
      'aktor_id' => new sfValidatorPropelChoice(array('model' => 'Aktor', 'column' => 'aktor_id', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('film_has_aktor[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'FilmHasAktor';
  }


}
