<?php

/**
 * Film form base class.
 *
 * @method Film getObject() Returns the current form's model object
 *
 * @package    filmy
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseFilmForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'film_id'             => new sfWidgetFormInputHidden(),
      'tytul'               => new sfWidgetFormInputText(),
      'slug'                => new sfWidgetFormInputText(),
      'film_has_aktor_list' => new sfWidgetFormPropelChoice(array('multiple' => true, 'model' => 'Aktor')),
    ));

    $this->setValidators(array(
      'film_id'             => new sfValidatorChoice(array('choices' => array($this->getObject()->getFilmId()), 'empty_value' => $this->getObject()->getFilmId(), 'required' => false)),
      'tytul'               => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'slug'                => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'film_has_aktor_list' => new sfValidatorPropelChoice(array('multiple' => true, 'model' => 'Aktor', 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Film', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('film[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Film';
  }


  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['film_has_aktor_list']))
    {
      $values = array();
      foreach ($this->object->getFilmHasAktors() as $obj)
      {
        $values[] = $obj->getAktorId();
      }

      $this->setDefault('film_has_aktor_list', $values);
    }

  }

  protected function doSave($con = null)
  {
    parent::doSave($con);

    $this->saveFilmHasAktorList($con);
  }

  public function saveFilmHasAktorList($con = null)
  {
    if (!$this->isValid())
    {
      throw $this->getErrorSchema();
    }

    if (!isset($this->widgetSchema['film_has_aktor_list']))
    {
      // somebody has unset this widget
      return;
    }

    if (null === $con)
    {
      $con = $this->getConnection();
    }

    $c = new Criteria();
    $c->add(FilmHasAktorPeer::FILM_ID, $this->object->getPrimaryKey());
    FilmHasAktorPeer::doDelete($c, $con);

    $values = $this->getValue('film_has_aktor_list');
    if (is_array($values))
    {
      foreach ($values as $value)
      {
        $obj = new FilmHasAktor();
        $obj->setFilmId($this->object->getPrimaryKey());
        $obj->setAktorId($value);
        $obj->save();
      }
    }
  }

}
