<?php

class propelImportdanychTask extends sfBaseTask
{
  protected function configure()
  {
    // // add your own arguments here
    // $this->addArguments(array(
    //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
    // ));

    $this->addOptions(array(
      new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
      new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
      new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
      // add your own options here
    ));

    $this->namespace        = 'propel';
    $this->name             = 'import-danych';
    $this->briefDescription = '';
    $this->detailedDescription = <<<EOF
The [propel:import-danych|INFO] task does things.
Call it with:

  [php symfony propel:import-danych|INFO]
EOF;
  }

  protected function execute($arguments = array(), $options = array())
  {
    // initialize the database connection
    $databaseManager = new sfDatabaseManager($this->configuration);
    $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

    // add your code here

    FilmHasAktorPeer::doDeleteAll();
    AktorPeer::doDeleteAll();
    FilmPeer::doDeleteAll();

    require_once 'lib/pomocnicze.inc.php';
    require_once 'lib/slugs.inc.php';
    $plk = file('data/filmy.txt');
    shuffle($plk);
    foreach ($plk as $linia) {
        $tmp = parsuj_film(trim($linia));

        echo $tmp['tytul'] . "\n";

        $c = new Criteria();
        $c->add(FilmPeer::TYTUL, $tmp['tytul']);
        $film = FilmPeer::doSelectOne($c);
        if (!$film) {
            $film = new Film();
            $film->setTytul($tmp['tytul']);
            $film->setSlug(string2slug($tmp['tytul']));
            $film->save();
        }

        foreach ($tmp['aktorzy'] as $a) {
            $c = new Criteria();
            $c->add(AktorPeer::IMIE, $a['imie']);
            $c->add(AktorPeer::NAZWISKO, $a['nazwisko']);
            $aktor = AktorPeer::doSelectOne($c);
            if (!$aktor) {
                $aktor = new Aktor();
                $aktor->setImie($a['imie']);
                $aktor->setNazwisko($a['nazwisko']);
                $aktor->setSlug(string2slug($a['imie'] . ' ' . $a['nazwisko']));
                $aktor->save();
            }

            $fha = new FilmHasAktor();
            $fha->setFilm($film);
            $fha->setAktor($aktor);
            try {
                $fha->save();
            } catch (PropelException $e) {
                echo 'ERROR: ' . $e->getMessage() . '<br />';
            }

        }
    }




  }
}
