<?php

/**
 * Aktor form base class.
 *
 * @method Aktor getObject() Returns the current form's model object
 *
 * @package    filmy
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseAktorForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'aktor_id'            => new sfWidgetFormInputHidden(),
      'imie'                => new sfWidgetFormInputText(),
      'nazwisko'            => new sfWidgetFormInputText(),
      'slug'                => new sfWidgetFormInputText(),
      'film_has_aktor_list' => new sfWidgetFormPropelChoice(array('multiple' => true, 'model' => 'Film')),
    ));

    $this->setValidators(array(
      'aktor_id'            => new sfValidatorChoice(array('choices' => array($this->getObject()->getAktorId()), 'empty_value' => $this->getObject()->getAktorId(), 'required' => false)),
      'imie'                => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'nazwisko'            => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'slug'                => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'film_has_aktor_list' => new sfValidatorPropelChoice(array('multiple' => true, 'model' => 'Film', 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Aktor', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('aktor[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Aktor';
  }


  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['film_has_aktor_list']))
    {
      $values = array();
      foreach ($this->object->getFilmHasAktors() as $obj)
      {
        $values[] = $obj->getFilmId();
      }

      $this->setDefault('film_has_aktor_list', $values);
    }

  }

  protected function doSave($con = null)
  {
    parent::doSave($con);

    $this->saveFilmHasAktorList($con);
  }

  public function saveFilmHasAktorList($con = null)
  {
    if (!$this->isValid())
    {
      throw $this->getErrorSchema();
    }

    if (!isset($this->widgetSchema['film_has_aktor_list']))
    {
      // somebody has unset this widget
      return;
    }

    if (null === $con)
    {
      $con = $this->getConnection();
    }

    $c = new Criteria();
    $c->add(FilmHasAktorPeer::AKTOR_ID, $this->object->getPrimaryKey());
    FilmHasAktorPeer::doDelete($c, $con);

    $values = $this->getValue('film_has_aktor_list');
    if (is_array($values))
    {
      foreach ($values as $value)
      {
        $obj = new FilmHasAktor();
        $obj->setAktorId($this->object->getPrimaryKey());
        $obj->setFilmId($value);
        $obj->save();
      }
    }
  }

}
