<?php

/**
 * Film filter form base class.
 *
 * @package    filmy
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseFilmFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'tytul'               => new sfWidgetFormFilterInput(),
      'slug'                => new sfWidgetFormFilterInput(),
      'film_has_aktor_list' => new sfWidgetFormPropelChoice(array('model' => 'Aktor', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'tytul'               => new sfValidatorPass(array('required' => false)),
      'slug'                => new sfValidatorPass(array('required' => false)),
      'film_has_aktor_list' => new sfValidatorPropelChoice(array('model' => 'Aktor', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('film_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function addFilmHasAktorListColumnCriteria(Criteria $criteria, $field, $values)
  {
    if (!is_array($values))
    {
      $values = array($values);
    }

    if (!count($values))
    {
      return;
    }

    $criteria->addJoin(FilmHasAktorPeer::FILM_ID, FilmPeer::FILM_ID);

    $value = array_pop($values);
    $criterion = $criteria->getNewCriterion(FilmHasAktorPeer::AKTOR_ID, $value);

    foreach ($values as $value)
    {
      $criterion->addOr($criteria->getNewCriterion(FilmHasAktorPeer::AKTOR_ID, $value));
    }

    $criteria->add($criterion);
  }

  public function getModelName()
  {
    return 'Film';
  }

  public function getFields()
  {
    return array(
      'film_id'             => 'Number',
      'tytul'               => 'Text',
      'slug'                => 'Text',
      'film_has_aktor_list' => 'ManyKey',
    );
  }
}
