<?php

require_once 'slugs.inc.php';
require_once 'html.inc.php';
require_once 'toc.inc.php';

class myParser
{
    public static function parseArticle($filename)
    {
        $tmp   = file_get_contents($filename);

        $tytul  = trim(htmlGetTagsContent($tmp, 'h1'));
        $autor  = trim(htmlGetTagsContent($tmp, 'h2'));
        $body   = trim(htmlGetTagsContent($tmp, 'body'));
        $lid    = trim(htmlGetFirstMatch($tmp, '|<p class="lid">(.*)</p>|Usim'));

        $body  = htmlDeleteTag($body, 'h1');
        $body  = htmlDeleteTag($body, 'h2');
        $body  = htmlSetFirstMatch($body, '|(<p class="lid">.*</p>)|Usim', '');

        $body  = trim($body);

        $tablicaTOC = getTableOfContents($body);
        $napisTOC   = getTableOfContentsAsString($tablicaTOC);
        $body       = replaceChapters($tablicaTOC, $body);


        $body = preg_replace('/<img src="images\/([^"]+)"/Usim', '<img src="/artykuly/web/artimg/\\1"', $body);
        $body = str_replace('<pre>', '<pre class="syntax-highlight:xml">', $body);

        $artykul_dane = array(
            'tytul'      => $tytul,
            'slug'       => string2slug($tytul),
            'tresc'      => $body,
            'lid'        => $lid,
            'spistresci' => $napisTOC
        );
        return $artykul_dane;
    }
}




