<?php

/**
 * piosenka actions.
 *
 * @package    piosenki-wojskowe
 * @subpackage piosenka
 * @author     Your name here
 */
class piosenkaActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->Piosenkas = PiosenkaPeer::doSelect(new Criteria());
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->form = new PiosenkaForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new PiosenkaForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->forward404Unless($Piosenka = PiosenkaPeer::retrieveByPk($request->getParameter('piosenka_id')), sprintf('Object Piosenka does not exist (%s).', $request->getParameter('piosenka_id')));
    $this->form = new PiosenkaForm($Piosenka);
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($Piosenka = PiosenkaPeer::retrieveByPk($request->getParameter('piosenka_id')), sprintf('Object Piosenka does not exist (%s).', $request->getParameter('piosenka_id')));
    $this->form = new PiosenkaForm($Piosenka);

    $this->processForm($request, $this->form);

    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->forward404Unless($Piosenka = PiosenkaPeer::retrieveByPk($request->getParameter('piosenka_id')), sprintf('Object Piosenka does not exist (%s).', $request->getParameter('piosenka_id')));
    $Piosenka->delete();

    $this->redirect('piosenka/index');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $Piosenka = $form->save();

      $this->redirect('piosenka/edit?piosenka_id='.$Piosenka->getPiosenkaId());
    }
  }
}
