<?php

/**
 * Aktor filter form base class.
 *
 * @package    filmy
 * @subpackage filter
 * @author     Your name here
 */
abstract class BaseAktorFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'imie'                => new sfWidgetFormFilterInput(),
      'nazwisko'            => new sfWidgetFormFilterInput(),
      'slug'                => new sfWidgetFormFilterInput(),
      'film_has_aktor_list' => new sfWidgetFormPropelChoice(array('model' => 'Film', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'imie'                => new sfValidatorPass(array('required' => false)),
      'nazwisko'            => new sfValidatorPass(array('required' => false)),
      'slug'                => new sfValidatorPass(array('required' => false)),
      'film_has_aktor_list' => new sfValidatorPropelChoice(array('model' => 'Film', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('aktor_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function addFilmHasAktorListColumnCriteria(Criteria $criteria, $field, $values)
  {
    if (!is_array($values))
    {
      $values = array($values);
    }

    if (!count($values))
    {
      return;
    }

    $criteria->addJoin(FilmHasAktorPeer::AKTOR_ID, AktorPeer::AKTOR_ID);

    $value = array_pop($values);
    $criterion = $criteria->getNewCriterion(FilmHasAktorPeer::FILM_ID, $value);

    foreach ($values as $value)
    {
      $criterion->addOr($criteria->getNewCriterion(FilmHasAktorPeer::FILM_ID, $value));
    }

    $criteria->add($criterion);
  }

  public function getModelName()
  {
    return 'Aktor';
  }

  public function getFields()
  {
    return array(
      'aktor_id'            => 'Number',
      'imie'                => 'Text',
      'nazwisko'            => 'Text',
      'slug'                => 'Text',
      'film_has_aktor_list' => 'ManyKey',
    );
  }
}
