<?php

/**
 * Tren form base class.
 *
 * @method Tren getObject() Returns the current form's model object
 *
 * @package    treny
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseTrenForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'tren_id' => new sfWidgetFormInputHidden(),
      'tytul'   => new sfWidgetFormInputText(),
      'tresc'   => new sfWidgetFormTextarea(),
      'slug'    => new sfWidgetFormInputText(),
      'numer'   => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'tren_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getTrenId()), 'empty_value' => $this->getObject()->getTrenId(), 'required' => false)),
      'tytul'   => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'tresc'   => new sfValidatorString(array('required' => false)),
      'slug'    => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'numer'   => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Tren', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('tren[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Tren';
  }


}
