<?php

class propelImportdanychTask extends sfBaseTask
{
  protected function configure()
  {
    // // add your own arguments here
    // $this->addArguments(array(
    //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
    // ));

    $this->addOptions(array(
      new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
      new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
      new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
      // add your own options here
    ));

    $this->namespace        = 'propel';
    $this->name             = 'import-danych';
    $this->briefDescription = 'wypelnianie bazy danych plikami .html';
    $this->detailedDescription = <<<EOF
Zadanie [propel:import-danych|INFO] wypełnia bazę danych plikami .html
zawartymi w folderze data/artykuly/.
Wywolanie:

  [php symfony propel:import-danych|INFO]
EOF;
  }

  protected function execute($arguments = array(), $options = array())
  {
    // initialize the database connection
    $databaseManager = new sfDatabaseManager($this->configuration);
    $connection = $databaseManager->getDatabase($options['connection'])->getConnection();


    ArtykulPeer::doDeleteAll();
    $plks = glob('data/artykuly/*.html');
    foreach ($plks as $plk) {
        echo $plk . "\n";
        $dane = myParser::parseArticle($plk);
        ArtykulPeer::insert($dane);
    }

  }
}
