<?php

/**
 * Turniej form base class.
 *
 * @method Turniej getObject() Returns the current form's model object
 *
 * @package    tcs
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseTurniejForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'turniej_id' => new sfWidgetFormInputHidden(),
      'rok'        => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'turniej_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getTurniejId()), 'empty_value' => $this->getObject()->getTurniejId(), 'required' => false)),
      'rok'        => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('turniej[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Turniej';
  }


}
