
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- turniej
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `turniej`;


CREATE TABLE `turniej`
(
	`turniej_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rok` INTEGER,
	PRIMARY KEY (`turniej_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- zawodnik
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `zawodnik`;


CREATE TABLE `zawodnik`
(
	`zawodnik_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`imie` VARCHAR(45),
	`nazwisko` VARCHAR(45),
	`panstwo_id` INTEGER,
	PRIMARY KEY (`zawodnik_id`),
	KEY `fk_zawodnik_panstwo`(`panstwo_id`),
	CONSTRAINT `zawodnik_FK_1`
		FOREIGN KEY (`panstwo_id`)
		REFERENCES `panstwo` (`panstwo_id`)
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- panstwo
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `panstwo`;


CREATE TABLE `panstwo`
(
	`panstwo_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`panstwo` VARCHAR(128),
	PRIMARY KEY (`panstwo_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- turniej_has_zawodnik
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `turniej_has_zawodnik`;


CREATE TABLE `turniej_has_zawodnik`
(
	`thz_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`turniej_id` INTEGER  NOT NULL,
	`zawodnik_id` INTEGER  NOT NULL,
	`miejsce` INTEGER,
	PRIMARY KEY (`thz_id`),
	KEY `fk_turniej_has_zawodnik_turniej1`(`turniej_id`),
	KEY `fk_turniej_has_zawodnik_zawodnik1`(`zawodnik_id`),
	CONSTRAINT `turniej_has_zawodnik_FK_1`
		FOREIGN KEY (`turniej_id`)
		REFERENCES `turniej` (`turniej_id`)
		ON DELETE CASCADE,
	CONSTRAINT `turniej_has_zawodnik_FK_2`
		FOREIGN KEY (`zawodnik_id`)
		REFERENCES `zawodnik` (`zawodnik_id`)
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
