<?php

/**
 * rozdzial actions.
 *
 * @package    cpp
 * @subpackage rozdzial
 * @author     Your name here
 */
class rozdzialActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->Rozdzials = RozdzialPeer::doSelect(new Criteria());
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->form = new RozdzialForm();
    $numer = RozdzialPeer::getMaxNumerRozdzialu();
    $this->form->getWidget('numer')->setDefault($numer + 1);
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new RozdzialForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->forward404Unless($Rozdzial = RozdzialPeer::retrieveByPk($request->getParameter('rozdzial_id')), sprintf('Object Rozdzial does not exist (%s).', $request->getParameter('rozdzial_id')));
    $this->form = new RozdzialForm($Rozdzial);
    $this->Rozdzial = $Rozdzial;
    $this->getUser()->setAttribute('prevUrl', 'rozdzial/edit?rozdzial_id=' . $Rozdzial->getRozdzialId());
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($Rozdzial = RozdzialPeer::retrieveByPk($request->getParameter('rozdzial_id')), sprintf('Object Rozdzial does not exist (%s).', $request->getParameter('rozdzial_id')));
    $this->form = new RozdzialForm($Rozdzial);

    $this->processForm($request, $this->form);

    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->forward404Unless($Rozdzial = RozdzialPeer::retrieveByPk($request->getParameter('rozdzial_id')), sprintf('Object Rozdzial does not exist (%s).', $request->getParameter('rozdzial_id')));
    $Rozdzial->delete();

    $this->redirect('rozdzial/index');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $Rozdzial = $form->save();

      $this->redirect('rozdzial/edit?rozdzial_id='.$Rozdzial->getRozdzialId());
    }
  }

  public function executeAutomat(sfWebRequest $request)
  {
    $Rozdzials = RozdzialPeer::doSelect(new Criteria());
    foreach ($Rozdzials as $k => $Rozdzial) {
        $Rozdzial->setNumer($k + 1);
        $Rozdzial->save();
        foreach ($Rozdzial->getZadanies() as $i => $Zadanie) {
            $Zadanie->setNumer($i + 1);
            $Zadanie->setSlug('');
            $Zadanie->save();
        }
    }
    $url = $this->getUser()->getAttribute('prevUrl', 'zadanie/index');
    $this->redirect($url);
  }

}
