<?php

/**
 * Rodzina form base class.
 *
 * @method Rodzina getObject() Returns the current form's model object
 *
 * @package    zengardencss
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseRodzinaForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'rodzina_id'      => new sfWidgetFormInputHidden(),
      'nazwa'           => new sfWidgetFormInputText(),
      'slug'            => new sfWidgetFormInputText(),
      'liczbaczcionek'  => new sfWidgetFormInputText(),
      'liczbaprojektow' => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'rodzina_id'      => new sfValidatorChoice(array('choices' => array($this->getObject()->getRodzinaId()), 'empty_value' => $this->getObject()->getRodzinaId(), 'required' => false)),
      'nazwa'           => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'slug'            => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'liczbaczcionek'  => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'liczbaprojektow' => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Rodzina', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('rodzina[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Rodzina';
  }


}
