<?php

/**
 * Projekt form base class.
 *
 * @method Projekt getObject() Returns the current form's model object
 *
 * @package    zengardencss
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseProjektForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'projekt_id'                => new sfWidgetFormInputHidden(),
      'nazwa'                     => new sfWidgetFormInputText(),
      'slug'                      => new sfWidgetFormInputText(),
      'liczbaczcionek'            => new sfWidgetFormInputText(),
      'projekt_has_czcionka_list' => new sfWidgetFormPropelChoice(array('multiple' => true, 'model' => 'Czcionka')),
    ));

    $this->setValidators(array(
      'projekt_id'                => new sfValidatorChoice(array('choices' => array($this->getObject()->getProjektId()), 'empty_value' => $this->getObject()->getProjektId(), 'required' => false)),
      'nazwa'                     => new sfValidatorString(array('max_length' => 5, 'required' => false)),
      'slug'                      => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'liczbaczcionek'            => new sfValidatorInteger(array('min' => -2147483648, 'max' => 2147483647, 'required' => false)),
      'projekt_has_czcionka_list' => new sfValidatorPropelChoice(array('multiple' => true, 'model' => 'Czcionka', 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Projekt', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('projekt[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Projekt';
  }


  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['projekt_has_czcionka_list']))
    {
      $values = array();
      foreach ($this->object->getProjektHasCzcionkas() as $obj)
      {
        $values[] = $obj->getCzcionkaId();
      }

      $this->setDefault('projekt_has_czcionka_list', $values);
    }

  }

  protected function doSave($con = null)
  {
    parent::doSave($con);

    $this->saveProjektHasCzcionkaList($con);
  }

  public function saveProjektHasCzcionkaList($con = null)
  {
    if (!$this->isValid())
    {
      throw $this->getErrorSchema();
    }

    if (!isset($this->widgetSchema['projekt_has_czcionka_list']))
    {
      // somebody has unset this widget
      return;
    }

    if (null === $con)
    {
      $con = $this->getConnection();
    }

    $c = new Criteria();
    $c->add(ProjektHasCzcionkaPeer::PROJEKT_ID, $this->object->getPrimaryKey());
    ProjektHasCzcionkaPeer::doDelete($c, $con);

    $values = $this->getValue('projekt_has_czcionka_list');
    if (is_array($values))
    {
      foreach ($values as $value)
      {
        $obj = new ProjektHasCzcionka();
        $obj->setProjektId($this->object->getPrimaryKey());
        $obj->setCzcionkaId($value);
        $obj->save();
      }
    }
  }

}
