<?php

/**
 * Img form base class.
 *
 * @method Img getObject() Returns the current form's model object
 *
 * @package    zengardencss
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseImgForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'img_id' => new sfWidgetFormInputHidden(),
      'image'  => new sfWidgetFormInputText(),
      'slug'   => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'img_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->getImgId()), 'empty_value' => $this->getObject()->getImgId(), 'required' => false)),
      'image'  => new sfValidatorPass(array('required' => false)),
      'slug'   => new sfValidatorString(array('max_length' => 128, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Img', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('img[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Img';
  }


}
