<?php

/**
 * Platforma filter form base class.
 *
 * @package    zengardencss
 * @subpackage filter
 * @author     Your name here
 */
abstract class BasePlatformaFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'nazwa'           => new sfWidgetFormFilterInput(),
      'slug'            => new sfWidgetFormFilterInput(),
      'liczbaczcionek'  => new sfWidgetFormFilterInput(),
      'liczbaprojektow' => new sfWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'nazwa'           => new sfValidatorPass(array('required' => false)),
      'slug'            => new sfValidatorPass(array('required' => false)),
      'liczbaczcionek'  => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'liczbaprojektow' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
    ));

    $this->widgetSchema->setNameFormat('platforma_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Platforma';
  }

  public function getFields()
  {
    return array(
      'platforma_id'    => 'Number',
      'nazwa'           => 'Text',
      'slug'            => 'Text',
      'liczbaczcionek'  => 'Number',
      'liczbaprojektow' => 'Number',
    );
  }
}
