<?php

/**
 * Miasto form base class.
 *
 * @method Miasto getObject() Returns the current form's model object
 *
 * @package    kontynenty
 * @subpackage form
 * @author     Your name here
 */
abstract class BaseMiastoForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'miasto_id'  => new sfWidgetFormInputHidden(),
      'nazwa'      => new sfWidgetFormInputText(),
      'slug'       => new sfWidgetFormInputText(),
      'panstwo_id' => new sfWidgetFormPropelChoice(array('model' => 'Panstwo', 'add_empty' => false)),
    ));

    $this->setValidators(array(
      'miasto_id'  => new sfValidatorChoice(array('choices' => array($this->getObject()->getMiastoId()), 'empty_value' => $this->getObject()->getMiastoId(), 'required' => false)),
      'nazwa'      => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'slug'       => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'panstwo_id' => new sfValidatorPropelChoice(array('model' => 'Panstwo', 'column' => 'panstwo_id')),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Miasto', 'column' => array('slug')))
    );

    $this->widgetSchema->setNameFormat('miasto[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Miasto';
  }


}
